﻿#include "StdAfx.h"
#include "AqDGSDKPTL_API.h"

AqDGI3C::AqDGI3C()
{
	
#ifdef _WIN64
		const char * szDLLName = "AqDGI3C64.dll";
#else
		const char * szDLLName = "AqDGI3C.dll";
#endif


	if( ( m_hI3CCvt = LoadLibrary( szDLLName ) ) == NULL )
	{
		DWORD dw = GetLastError();
		return;
	}

	pInitProtocol = (PINITPROTOCOLSDK)GetProcAddress(m_hI3CCvt, "InitProtocol");
	pCloseProtocol = (PCLOSEPROTOCOLSDK)GetProcAddress(m_hI3CCvt, "CloseProtocol");
	pGethDGPtl = (PGETHDGPTL)GetProcAddress(m_hI3CCvt, "GethDGPtl");
	pGetVoltGrpNum = (PGETVOLTGRPNUM)GetProcAddress(m_hI3CCvt, "GetVoltGrpNum");
	pSetOutputVolt = (PSETOUTPUTVOLT)GetProcAddress(m_hI3CCvt, "SetOutputVolt");
	pGetLastErrorEx = (PGETLASTDGERROR)GetProcAddress(m_hI3CCvt, "GetLastErrorEx");
	pClearAllPattern = (PCLEARALLPATTERN)GetProcAddress(m_hI3CCvt, "ClearAllPattern");
	pClearPatternByOrder = (PCLEARPATTERNBYORDER)GetProcAddress(m_hI3CCvt, "ClearPatternByOrder");
	pClearPattern = (PCLEARPATTERN)GetProcAddress(m_hI3CCvt, "ClearPattern");
	pMerge = (PMERGE)GetProcAddress(m_hI3CCvt, "MergeEx");
	pSavePattern = (PSAVEPATTERN)GetProcAddress(m_hI3CCvt, "SavePattern");
	pAppendDGInstruction = (PAPPENDDGINSTRUCTION)GetProcAddress(m_hI3CCvt, "AppendDGInstruction");
	pOutputPacketList = (POUTPUTPACKETLIST)GetProcAddress(m_hI3CCvt, "OutputPacketList");
	pAdjustPhase = (PADJPHASE)GetProcAddress(m_hI3CCvt, "AdjustPhase");
	pIsTD = (PISTD)GetProcAddress(m_hI3CCvt, "IsTD");

	pI3C_Settings = (PI3C_SETTINGS)GetProcAddress(m_hI3CCvt, "I3C_Settings");

	pI3C_Start = (PI3C_START)GetProcAddress(m_hI3CCvt, "I3C_Start");
	pI3C_SDR = (PI3C_SDR)GetProcAddress(m_hI3CCvt, "I3C_SDR");
	pI3C_HDR = (PI3C_HDR)GetProcAddress(m_hI3CCvt, "I3C_HDR");
	pI3C_TSX = (PI3C_TSX)GetProcAddress(m_hI3CCvt, "I3C_TSX");
	pI3C_Stop = (PI3C_STOP)GetProcAddress(m_hI3CCvt, "I3C_Stop");
	pI3C_Idle = (PI3C_IDLE)GetProcAddress(m_hI3CCvt, "I3C_Idle");
	
	pFindDev = (PFINDDEV)GetProcAddress(m_hI3CCvt, "FindDev");

}

AqDGI3C::~AqDGI3C()
{
		if( m_hI3CCvt )
			FreeLibrary( m_hI3CCvt );
}

HDGPTL AqDGI3C::InitProtocol()
{
	return pInitProtocol();
}

bool AqDGI3C::CloseProtocol()
{
	return pCloseProtocol();
}

HDGPTL AqDGI3C::GethDGPtl()
{
	return pGethDGPtl();
}

UINT32 AqDGI3C::GetVoltGrpNum()
{
	return pGetVoltGrpNum();
}
bool AqDGI3C::SetOutputVolt(UINT32 imV, UINT32 iVoltGrpIdx)
{
	return pSetOutputVolt(imV, iVoltGrpIdx);
}

UINT32 AqDGI3C::GetLastErrorEx()
{
	return pGetLastErrorEx();
}

bool AqDGI3C::ClearAllPattern()
{
	return pClearAllPattern();
}

bool AqDGI3C::ClearPatternByOrder(int iIdx)
{
	return pClearPatternByOrder(iIdx);
}

bool AqDGI3C::ClearPattern()
{
	return pClearPattern();
}

bool AqDGI3C::Merge(HDGPTL hDGPtl[], UINT32 hDGPtlSize)
{
	return pMerge(hDGPtl, hDGPtlSize);
}

UINT32 AqDGI3C::SavePattern(char* pStrFileName, UINT32 iFileType)
{
	return pSavePattern(pStrFileName, iFileType);
}

bool AqDGI3C::AppendDGInstruction(DGADDR iDGAddr, UINT32 iInst, UINT32 iParam)
{
	return pAppendDGInstruction(iDGAddr, iInst, iParam);
}

bool AqDGI3C::OutputPacketList(bool fOutput)
{
	return pOutputPacketList(fOutput);
}

int AqDGI3C::AdjustPhase(int iCh, int iDelay)
{
	return pAdjustPhase(iCh, iDelay);
}

bool AqDGI3C::I3C_Settings(HDGPTL hDGPtl, UINT32 iSCL, UINT32 iSDA[4], UINT32 iFreq, UINT32 iFreq2, __int64 i64timing[30])
{
	return pI3C_Settings(hDGPtl, iSCL, iSDA, iFreq, iFreq2, i64timing);
}

DGADDR AqDGI3C::I3C_Start(HDGPTL hDGPtl, DGADDR i64CurrIdx, bool fRepeatStart)
{
	return pI3C_Start(hDGPtl, i64CurrIdx, fRepeatStart);
}

DGADDR AqDGI3C::I3C_SDR(HDGPTL hDGPtl, DGADDR i64CurrIdx, int iType, UINT8 ui8Data, bool fHiZ)
{
	return pI3C_SDR(hDGPtl, i64CurrIdx, iType, ui8Data, fHiZ);
}

DGADDR AqDGI3C::I3C_HDR(HDGPTL hDGPtl, DGADDR i64CurrIdx, int iType, UINT8 ui8Data, bool fHiZ)
{
	return pI3C_HDR(hDGPtl, i64CurrIdx, iType, ui8Data, fHiZ);
}

DGADDR AqDGI3C::I3C_TSX(HDGPTL hDGPtl, DGADDR i64CurrIdx, int iType, UINT16 ui16Data, bool fHiZ)
{
	return pI3C_TSX(hDGPtl, i64CurrIdx, iType, ui16Data,  fHiZ);
}

DGADDR AqDGI3C::I3C_Stop(HDGPTL hDGPtl, DGADDR i64CurrIdx)
{
	return pI3C_Stop(hDGPtl, i64CurrIdx);
}

DGADDR AqDGI3C::I3C_Idle(HDGPTL hDGPtl, DGADDR i64CurrIdx, __int64 i64IdleTime)
{
	return pI3C_Idle(hDGPtl, i64CurrIdx, i64IdleTime);
}


bool AqDGI3C::IsTD()
{
	return pIsTD();
}


UINT32 AqDGI3C::FindDev()
{
		return pFindDev();
}