
// AqI3CDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AqI3CDemo.h"
#include "AqI3CDemoDlg.h"
#include "afxdialogex.h"
#include "cSetI3CTimingDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About
DG_HW_INFO CAqI3CDemoDlg::m_dgHwInfo[] = 
{
	{MODEL_TD3216B,			"TD3216B"},
	{MODEL_TD3116B,			"TD3116B"},
	{MODEL_TD3008E,			"TD3008E"},
	{MODEL_DG3128B,			"DG3128B"},
	{MODEL_DG3096B,			"DG3096B"},
	{MODEL_DG3064B,			"DG3064B"},
    {MODEL_DG4128B,			"DG4128B"},
    {MODEL_DG4096B,			"DG4096B"},
    {MODEL_DG4064B,			"DG4064B"},
    {MODEL_DG3112B,			"DG3128B"},
    {MODEL_DG3080B,			"DG3096B"},
    {MODEL_DG3048B,			"DG3064B"},



	{0,											NULL}
};

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CAqI3CDemoDlg dialog




CAqI3CDemoDlg::CAqI3CDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CAqI3CDemoDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	DefaultTiming();

}

void CAqI3CDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CB_DG_COMMFOMAT, m_cbCommFormat);
	DDX_Control(pDX, IDC_SP_DG_SCL, m_spDGSCL);
	DDX_Control(pDX, IDC_ST_DG_SCL, m_stDGSCL);
	DDX_Control(pDX, IDC_SP_DG_SDA, m_spDGSDA);
	DDX_Control(pDX, IDC_ST_DG_SDA, m_stDGSDA);
	DDX_Control(pDX, IDC_BN_DG_ACTIMING, m_bnAcTiming);
	DDX_Control(pDX, IDC_BN_DG_FREQ, m_bnFreqUnit);
	DDX_Control(pDX, IDC_SP_DG_FREQ, m_spFreq);
	DDX_Control(pDX, IDC_BN_DG_FREQ2, m_bnFreqUnit2);
	DDX_Control(pDX, IDC_SP_DG_FREQ2, m_spFreq2);
	DDX_Control(pDX, IDC_ST_DG_DESC, m_stDesc);
	DDX_Control(pDX, IDC_ED_DG_FREQ, m_edFreq);
	DDX_Control(pDX, IDC_ED_DG_FREQ2, m_edFreq2);


	DDX_Control(pDX, IDC_BN_GETHW, m_bnGetHW);
	DDX_Control(pDX, IDC_BN_RUN, m_bnRun);
	DDX_Control(pDX, IDC_BN_STOP, m_bnStop);
	DDX_Control(pDX, IDC_ST_DGMODEL, m_stDGModel);
	DDX_Control(pDX, IDC_CB_OUTPUTLVL, m_cbOutputLvl);
}

BEGIN_MESSAGE_MAP(CAqI3CDemoDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CTLCOLOR()
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_BN_DG_FREQ, &CAqI3CDemoDlg::OnBnClickedBnDgFreq)
	ON_EN_CHANGE(IDC_ED_DG_FREQ, &CAqI3CDemoDlg::OnEnChangeEdDgFreq)
	ON_CBN_SELCHANGE(IDC_CB_DG_COMMFOMAT, &CAqI3CDemoDlg::OnCbnSelchangeCbDgCommfomat)
	ON_BN_CLICKED(IDC_BN_DG_ACTIMING, &CAqI3CDemoDlg::OnBnClickedBnDgActiming)
	ON_BN_CLICKED(IDC_BN_GETHW, &CAqI3CDemoDlg::OnBnClickedBnGethw)
	ON_BN_CLICKED(IDC_BN_RUN, &CAqI3CDemoDlg::OnBnClickedBnRun)
	ON_BN_CLICKED(IDC_BN_STOP, &CAqI3CDemoDlg::OnBnClickedBnStop)
	ON_EN_CHANGE(IDC_ED_DG_FREQ2, &CAqI3CDemoDlg::OnEnChangeEdDgFreq2)
	ON_BN_CLICKED(IDC_BN_DG_FREQ2, &CAqI3CDemoDlg::OnBnClickedBnDgFreq2)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SP_DG_FREQ, &CAqI3CDemoDlg::OnDeltaposSpDgFreq)
	ON_BN_CLICKED(IDC_BN_DEFAULT, &CAqI3CDemoDlg::OnBnClickedBnDefault)
END_MESSAGE_MAP()


// CAqI3CDemoDlg message handlers


char *pStrI3CFormat[]  = 
{
	"Legacy I2C Transfer without 7'h7E Address",
	"Legacy I2C Write Transfer with 7'h7E Address",
	"Legacy I2C Read Transfer with 7'h7E Address",
	"I3C Private Write",
	"I3C Private Read",
	"I3C Broadcast CCC Write",
	"I3C Directed CCC Write",
	"I3C Directed CCC Read",
	"I3C_ENTDAA_CCC Format",
	"I3C Enter HDR-DDR Mode Format"	,
	NULL

};

int CAqI3CDemoDlg::m_iFreqVal[] = {1000, 1000000};
BOOL CAqI3CDemoDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_handle = INVALID_HANDLE;
	m_fDGConn = m_fLAConn = false;

	m_font.CreatePointFont(80, "Tahoma");
	for(int i = 0; pStrI3CFormat[i] != NULL; i++) 
		m_cbCommFormat.AddString(pStrI3CFormat[i]);
	m_cbCommFormat.SetCurSel(0);
	m_cbOutputLvl.SetCurSel(2);

	m_bnRun.EnableWindow(false);
	m_bnStop.EnableWindow(false);

	m_spDGSCL.SetRange(0,31);	
	m_spDGSCL.SetBase(1);			
	m_spDGSCL.SetPos32(0);	

	m_spDGSDA.SetRange(0,31);	
	m_spDGSDA.SetBase(1);			
	m_spDGSDA.SetPos32(1);

	m_iFreqUnit = 0;
	m_spFreq.SetRange32(1, (int)(1E8/m_iFreqVal[m_iFreqUnit%2]));
	m_spFreq.SetBase(1);
	m_spFreq.SetPos32(400); // 400 KHz

	m_iFreqUnit2 = 1;
	m_spFreq2.SetRange32(1, (int)(1E8 / m_iFreqVal[m_iFreqUnit2 % 2]));
	m_spFreq2.SetBase(1);
	m_spFreq2.SetPos32(1); // 400 KHz

	UpdateSpin2Edit();
	OnCbnSelchangeCbDgCommfomat();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAqI3CDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAqI3CDemoDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAqI3CDemoDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


#define FORMAT_DISP_COLOR RGB(153, 204, 255)
#define GET_DGHW_COLOR RGB(227, 207,87)
HBRUSH CAqI3CDemoDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	// TODO:  Change any attributes of the DC here
	switch(pWnd->GetDlgCtrlID())
	{
	case IDC_CB_DG_COMMFOMAT:
		{
			HBRUSH hbr_FormatDir = ::CreateSolidBrush(FORMAT_DISP_COLOR);
			pDC->SetBkMode(TRANSPARENT);
			pDC->SetBkColor(FORMAT_DISP_COLOR);		
			hbr = hbr_FormatDir;
		}
		break;

	case IDC_ST_DG_DESC:
		pDC->SelectObject(&m_font);
		break;

	case IDC_ST_DGMODEL:
		if(m_fDGConn)
		{
			HBRUSH hbr_GetDGHW = ::CreateSolidBrush(GET_DGHW_COLOR);
			pDC->SetBkMode(TRANSPARENT);
			pDC->SetBkColor(GET_DGHW_COLOR);		
			hbr = hbr_GetDGHW;
		}
		break;

	}
	// TODO:  Return a different brush if the default is not desired
	return hbr;
}

void CAqI3CDemoDlg::UpdateSpin2Edit(void)
{
	UpdateSpin2Edit(&m_stDGSCL, m_spDGSCL.GetPos32());
	UpdateSpin2Edit(&m_stDGSDA, m_spDGSDA.GetPos32());
	UpdateSpin2EditEx(&m_edFreq, m_spFreq.GetPos32());
	UpdateSpin2EditEx(&m_edFreq2, m_spFreq2.GetPos32());
}

void CAqI3CDemoDlg::UpdateSpin2Edit(CStatic* pstCh, int iVal)
{
	CString csChannelName;
	csChannelName.Format(_T("CH %d"), iVal);
	pstCh->SetWindowText(csChannelName.GetBuffer());
}


void CAqI3CDemoDlg::UpdateSpin2EditEx(CEdit* pedFreq, int iVal)
{
	CString csFreqVal;
	csFreqVal.Format("%.2f", (double)iVal);
	pedFreq->SetWindowText(csFreqVal.GetBuffer());
}


void CAqI3CDemoDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar *pScrollBar)
{
	CString csFreq;
	
	if(pScrollBar->m_hWnd == m_spFreq.m_hWnd)
	{
		if(SB_LINEUP==nSBCode)
			m_spFreq.SetPos32(m_spFreq.GetPos32()+1);
		else if(SB_LINEDOWN==nSBCode)
			m_spFreq.SetPos32(m_spFreq.GetPos32()-1);
		UpdateSpin2EditEx(&m_edFreq,  m_spFreq.GetPos32());
		ChkTiming();
	}
	else if (pScrollBar->m_hWnd == m_spFreq2.m_hWnd)
	{
		if (SB_LINEUP == nSBCode)
			m_spFreq2.SetPos32(m_spFreq2.GetPos32() + 1);
		else if (SB_LINEDOWN == nSBCode)
			m_spFreq2.SetPos32(m_spFreq2.GetPos32() - 1);
		UpdateSpin2EditEx(&m_edFreq2, m_spFreq2.GetPos32());
		ChkTiming();
	}
	else
	if(pScrollBar->m_hWnd == m_spDGSCL.m_hWnd)
	{
		if(SB_LINEUP==nSBCode)
			m_spDGSCL.SetPos32(m_spDGSCL.GetPos32()+1);
		else if(SB_LINEDOWN==nSBCode)
			m_spDGSCL.SetPos32(m_spDGSCL.GetPos32()-1);
		UpdateSpin2Edit(&m_stDGSCL, m_spDGSCL.GetPos32());
	}
	if(pScrollBar->m_hWnd == m_spDGSDA.m_hWnd)
	{
		if(SB_LINEUP==nSBCode)
			m_spDGSDA.SetPos32(m_spDGSDA.GetPos32()+1);
		else if(SB_LINEDOWN==nSBCode)
			m_spDGSDA.SetPos32(m_spDGSDA.GetPos32()-1);
		UpdateSpin2Edit(&m_stDGSDA, m_spDGSDA.GetPos32());
	}


}


char  *pStrFreqUnit[] = {"K Hz", "M Hz"};
void CAqI3CDemoDlg::OnBnClickedBnDgFreq()
{
	// TODO: Add your control notification handler code here
	m_bnFreqUnit.SetWindowTextA(pStrFreqUnit[(++m_iFreqUnit)%2]);
	OnEnChangeEdDgFreq();

	ChkTiming();
}

void CAqI3CDemoDlg::OnBnClickedBnDgFreq2()
{
	// TODO: Add your control notification handler code here
	m_bnFreqUnit2.SetWindowTextA(pStrFreqUnit[(++m_iFreqUnit2) % 2]);
	OnEnChangeEdDgFreq2();

	ChkTiming();
}


void CAqI3CDemoDlg::OnEnChangeEdDgFreq()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialogEx::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
	CString csFreq;
	m_edFreq.GetWindowTextA(csFreq);
	double dbFreq = _ttol(csFreq) * m_iFreqVal[m_iFreqUnit%2];
	
	if(dbFreq > 1E8)
	{
		dbFreq = 1E8;
		csFreq.Format("%.2f", dbFreq/m_iFreqVal[m_iFreqUnit%2]);
		m_edFreq.SetWindowTextA(csFreq.GetBuffer());	
	}
	m_spFreq.SetPos32((int)(dbFreq/m_iFreqVal[m_iFreqUnit%2]));

	ChkTiming();

}

void CAqI3CDemoDlg::OnEnChangeEdDgFreq2()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialogEx::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
	CString csFreq;
	m_edFreq2.GetWindowTextA(csFreq);
	double dbFreq = _ttol(csFreq) * m_iFreqVal[m_iFreqUnit2 % 2];

	if (dbFreq > 1E8)
	{
		dbFreq = 1E8;
		csFreq.Format("%.2f", dbFreq / m_iFreqVal[m_iFreqUnit2 % 2]);
		m_edFreq2.SetWindowTextA(csFreq.GetBuffer());
	}
	m_spFreq2.SetPos32((int)(dbFreq / m_iFreqVal[m_iFreqUnit2 % 2]));

	ChkTiming();

}

char* szBusType[] = { "Bus Type: Mixed Bus", "Bus Type: Pure Bus" };
char* szLegacyMode[]  = {"Legacy Mode: 400KHz/Fm", "Legacy Mode: 1MHz/Fm+"};
char* szTimingMode[] = { "Timing Mode: Open Drain", "Timing Mode: Push-Pull" };
void CAqI3CDemoDlg::OnCbnSelchangeCbDgCommfomat()
{
	// TODO: Add your control notification handler code here
	char szDescription[1024] = {0};
	char szDescription0[1024] = { 0 };
	char szDescription1[1024] = { 0 };
	char szDescription2[1024] = { 0 };
	m_stDesc.SetWindowTextA(szDescription);

	__int64 i64Display[30];
	for (int i = 0; i < 30; i++)
		i64Display[i] = m_i64Timing[i] / UNIT_NS;

		sprintf_s(szDescription0, "Legacy_I2C\ntSU_STA = %d ns\ntHD_STA = %d ns\ntLow = %d ns\ntHigh = %d ns\ntSU_DAT = %d ns\ntHD_DAT = %d ns\ntSU_STO = %d ns\ntBuf = %d ns\n",
			i64Display[IDX_tSU_STA_L], i64Display[IDX_tHD_STA_L], i64Display[IDX_tLOW_L], i64Display[IDX_tHIGH_L],
			i64Display[IDX_tSU_DAT_L], i64Display[IDX_tHD_DAT_L], i64Display[IDX_tSU_STO_L], i64Display[IDX_tBUF_L]);

		sprintf_s(szDescription1, "OD\ntLow = %d ns\ntHigh = %d ns\ntSU = %d ns\ntHD = %d ns\ntCAS = %d ns\ntCBP = %d ns\ntIDLE = %d ns\n",
			i64Display[IDX_tLOW_OD], i64Display[IDX_tHIGH_OD], i64Display[IDX_tSU_OD], i64Display[IDX_tHD_OD],
			i64Display[IDX_tCAS_OD], i64Display[IDX_tCBP_OD], i64Display[IDX_tIDLE_OD]);

		sprintf_s(szDescription2, "PP\ntLow = %d ns\ntHigh = %d ns\ntSCO = %d ns\ntSU = %d ns\ntHD = %d ns\ntCASr = %d ns\ntCBSr = %d ns\ntIDLE = %d ns\n",
			i64Display[IDX_tLOW_PP], i64Display[IDX_tHIGH_PP], i64Display[IDX_tSCO_PP], i64Display[IDX_tSU_PP],
			i64Display[IDX_tHD_PP], i64Display[IDX_tCASr_PP], i64Display[IDX_tCBSr_PP], i64Display[IDX_tIDLE_PP]);

		sprintf_s(szDescription, "%s%s%s", szDescription0, szDescription1, szDescription2);

	m_stDesc.SetWindowTextA(szDescription);

}


void CAqI3CDemoDlg::OnBnClickedBnDgActiming()
{
	// TODO: Add your control notification handler code here
	int iSelect = m_cbCommFormat.GetCurSel();
	//m_dgI3CTimingParams.iConnFormat = iSelect;
	cSetI3CTimingDlg dlg(m_i64Timing, this);
	if (dlg.DoModal() == IDOK)
	{
		for (int i = 0; i < 30; i++)
			m_i64Timing[i] = dlg.m_i64Timing[i];
		OnCbnSelchangeCbDgCommfomat();
	}
	

}


void CAqI3CDemoDlg::OnBnClickedBnGethw()
{
	// TODO: Add your control notification handler code here
	UINT32 iModel = m_DGI3C.FindDev();
	for(int i = 0; m_dgHwInfo[i].iModel != 0; i++)
	{
		if(m_dgHwInfo[i].iModel == iModel)
		{
			m_fDGConn = true;
			m_stDGModel.SetWindowTextA(m_dgHwInfo[i].szModel);
			m_bnRun.EnableWindow(true);
			m_bnGetHW.EnableWindow(false);
			break;
		}
	}
	
	if(m_fDGConn)
	{
		if((iModel & MODEL_MASK) == MODEL_DG3K_SERIES)
		{ // DG3K
			m_spDGSDA.SetPos32(16);
			UpdateSpin2Edit(&m_stDGSDA, m_spDGSDA.GetPos32());

		}
		else
		{// TD3K
			m_spDGSDA.SetPos32(1);
			UpdateSpin2Edit(&m_stDGSDA, m_spDGSDA.GetPos32());
		}

		m_handle = m_DGI3C.InitProtocol();

	}


}


void CAqI3CDemoDlg::OnBnClickedBnRun()
{
	// TODO: Add your control notification handler code here
	
	if(m_fDGConn)
	{
		UINT32 m_handle = m_DGI3C.InitProtocol();
	
		m_DGI3C.ClearAllPattern();

		UINT32 iSDA[4] = {1, 2, 3, 4};
		int iOutputlvl[] = {1200, 1800, 3300}; // 1.2V/1.8V/3.3Vw
		iSDA[0] = m_spDGSDA.GetPos32();

		CString csFreq;
		m_edFreq.GetWindowTextA(csFreq);
		double dbFreq = _ttol(csFreq) * m_iFreqVal[m_iFreqUnit%2];
		m_edFreq2.GetWindowTextA(csFreq);
		double dbFreq2 = _ttol(csFreq) * m_iFreqVal[m_iFreqUnit2 % 2];

		m_DGI3C.I3C_Settings(m_handle, m_spDGSCL.GetPos32(),  iSDA, dbFreq, dbFreq2, m_i64Timing);
		for(int i = 0; i < MAX_VOLT_GROUP_SIZE; i++)
			m_DGI3C.SetOutputVolt(iOutputlvl[m_cbOutputLvl.GetCurSel()], i);
		GeneI3CFormat(m_cbCommFormat.GetCurSel());

		unsigned int iHandleArray[1] = {m_handle};
		bool fMerge = m_DGI3C.Merge(iHandleArray, 1);

		if(fMerge)
		{
			m_DGI3C.SavePattern("I3C", 0);
			m_DGI3C.OutputPacketList(true);
		}

		m_DGI3C.ClearAllPattern();

		m_bnRun.EnableWindow(false);
		m_bnStop.EnableWindow(true);

		
		
	}

}


void CAqI3CDemoDlg::OnBnClickedBnStop()
{
	// TODO: Add your control notification handler code here
	m_DGI3C.OutputPacketList(false);
	m_DGI3C.ClearAllPattern();
	m_bnRun.EnableWindow(true);
	m_DGI3C.CloseProtocol();

}


#define TARGET_ADDR 0x10
#define BROADCAST_SETMWL_CCC 0x09
#define ENTHDR0_CCC 0x20 // HDR-DDR
#define DIRECTED_ENTAS0_CCC 0x82
#define HDR_DDR_CMD 0x7003

enum
{
	IDX_SDR_OD_8BIT = 0,
	IDX_SDR_PP_8BIT,
	IDX_SDR_OD_1BIT,
	IDX_SDR_PP_1BIT

};

enum
{
	IDX_HDR_RESTART = 0,
	IDX_HDR_PRE,
	IDX_HDR_DATA,
	IDX_HDR_CRC,
	IDX_HDR_PAR,
	IDX_HDR_EXIT,
	IDX_HDR_TSL,
	IDX_HDR_TSP,
};

void CAqI3CDemoDlg::GeneI3CFormat(int iSelect)
{

	UINT64 i64CurrIdx = 0;
	BYTE iWrDat[4] = {0x01, 0x02, 0x03, 0x04};
	BYTE iSETMWL_WrDat[2] = {0x01, 0x02}; //MWL MSB/LSB
	WORD wDat[] = {0x0200, 0x0000, 0x0211, 0x2200};


	i64CurrIdx = m_DGI3C.I3C_Idle(m_handle, i64CurrIdx, 10000000);

	switch(iSelect)
	{
	case Legacy_I2C_Transfer_Without_ResevByte:
		
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, TARGET_ADDR << 1, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, iWrDat[0], false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, true);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, (TARGET_ADDR << 1) | 1, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, iWrDat[0], false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Stop(m_handle, i64CurrIdx);
		break;

	case Legacy_I2C_Wr_Transfer_With_ResevByte:
		
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, TARGET_ADDR << 1, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, iWrDat[0], false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Stop(m_handle, i64CurrIdx);
		break;

	case Legacy_I2C_Rd_Transfer_With_ResevByte:
		
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, (TARGET_ADDR << 1) | 1, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, iWrDat[0], false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Stop(m_handle, i64CurrIdx);
		break;

	case I3C_Private_Write:
		
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, 0xfc, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, true);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x00, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x01, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Stop(m_handle, i64CurrIdx);
		break;

	case I3C_Private_Read:
		
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, 0xfc, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, true);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x01, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x02, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Stop(m_handle, i64CurrIdx);
		break;

	case I3C_Broadcast_CCC_Write:
		
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, 0xfc, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x00, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Stop(m_handle, i64CurrIdx); 
		break;

	case I3C_Directed_CCC_Write:
		
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, 0xfc, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x80, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Stop(m_handle, i64CurrIdx);
		break;

	case I3C_Directed_CCC_Read:
		
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, 0xfc, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x80, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, true);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x01, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x02, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Stop(m_handle, i64CurrIdx);
		break;

	case I3C_ENTDAA_CCC_Format:
		
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, 0xfc, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x07, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, true);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0xfd, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x59, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x00, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x00, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x00, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x01, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x26, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x64, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x08, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, true);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0xfd, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 1, false);
		i64CurrIdx = m_DGI3C.I3C_Stop(m_handle, i64CurrIdx);
		break;

	case I3C_Enter_HDR_DDR_Mode_Format:
		
		i64CurrIdx = m_DGI3C.I3C_Start(m_handle, i64CurrIdx, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_8BIT, 0xfc, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_OD_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_8BIT, 0x20, false);
		i64CurrIdx = m_DGI3C.I3C_SDR(m_handle, i64CurrIdx, IDX_SDR_PP_1BIT, 0, false);
		i64CurrIdx = m_DGI3C.I3C_HDR(m_handle, i64CurrIdx, IDX_HDR_PRE, 0x01, false);
		i64CurrIdx = m_DGI3C.I3C_HDR(m_handle, i64CurrIdx, IDX_HDR_DATA, 0x04, false);
		i64CurrIdx = m_DGI3C.I3C_HDR(m_handle, i64CurrIdx, IDX_HDR_DATA, 0x02, false);
		i64CurrIdx = m_DGI3C.I3C_HDR(m_handle, i64CurrIdx, IDX_HDR_PAR, 0x01, false);
		i64CurrIdx = m_DGI3C.I3C_Stop(m_handle, i64CurrIdx);
		break;

	}

	i64CurrIdx = m_DGI3C.I3C_Idle(m_handle, i64CurrIdx, 10000000);
}


void CAqI3CDemoDlg::OnDeltaposSpDgFreq(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);
	// TODO: b[JiBz`{X
	*pResult = 0;

	ChkTiming();
}


void CAqI3CDemoDlg::ChkTiming()
{
	CString csFreq;
	m_edFreq.GetWindowTextA(csFreq);
	double dbFreq = _ttol(csFreq) * m_iFreqVal[m_iFreqUnit % 2];
	m_edFreq2.GetWindowTextA(csFreq);
	double dbFreq2 = _ttol(csFreq) * m_iFreqVal[m_iFreqUnit2 % 2];

	DefaultTiming();
	double d1 = dbFreq / 400000;

	for (int i = 0; i < 20; i++)
		m_i64Timing[i] = m_i64Timing[i] / d1;

	double d2 = dbFreq2 / 1000000;

	for (int i = 20; i < 30; i++)
		m_i64Timing[i] = m_i64Timing[i] / d2;

	OnCbnSelchangeCbDgCommfomat();
}

void CAqI3CDemoDlg::DefaultTiming()
{
	// Legacy, 400 KHz
	m_i64Timing[IDX_tSU_STA_L] = 600 * UNIT_NS;
	m_i64Timing[IDX_tHD_STA_L] = 1300 * UNIT_NS;
	m_i64Timing[IDX_tLOW_L] = 1250 * UNIT_NS;
	m_i64Timing[IDX_tHIGH_L] = 1250 * UNIT_NS;
	m_i64Timing[IDX_tSU_DAT_L] = 100 * UNIT_NS;
	m_i64Timing[IDX_tHD_DAT_L] = 1150 * UNIT_NS;
	m_i64Timing[IDX_tSU_STO_L] = 600 * UNIT_NS;
	m_i64Timing[IDX_tBUF_L] = 1300 * UNIT_NS;

	// OD, 2.5 MHz
	m_i64Timing[IDX_tLOW_OD] = 1250 * UNIT_NS;
	m_i64Timing[IDX_tHIGH_OD] = 1250 * UNIT_NS;
	m_i64Timing[IDX_tSU_OD] = 40 * UNIT_NS;
	m_i64Timing[IDX_tHD_OD] = 1210 * UNIT_NS;
	m_i64Timing[IDX_tCAS_OD] = 30 * UNIT_NS;
	m_i64Timing[IDX_tCBP_OD] = 200 * UNIT_NS;
	m_i64Timing[IDX_tIDLE_OD] = 200 * UNIT_NS;

	// PP, 12.5 IDX_tLOW_PP
	m_i64Timing[IDX_tLOW_PP] = 500 * UNIT_NS;
	m_i64Timing[IDX_tHIGH_PP] = 500 * UNIT_NS;
	m_i64Timing[IDX_tSCO_PP] = 20 * UNIT_NS;
	m_i64Timing[IDX_tSU_PP] = 20 * UNIT_NS;
	m_i64Timing[IDX_tHD_PP] = 480 * UNIT_NS;
	m_i64Timing[IDX_tCASr_PP] = 40 * UNIT_NS;
	m_i64Timing[IDX_tCBSr_PP] = 200 * UNIT_NS;

	m_i64Timing[IDX_tIDLE_PP] = 200 * UNIT_NS;
}

void CAqI3CDemoDlg::OnBnClickedBnDefault()
{
	// TODO: b[JiBz`{X
	DefaultTiming();
	m_iFreqUnit = 0;
	m_iFreqUnit2 = 1;
	m_spFreq.SetPos32(400); // 400 KHz
	m_spFreq2.SetPos32(1); // 400 KHz

	UpdateSpin2Edit();
	OnCbnSelchangeCbDgCommfomat();
}
