﻿// cSetI3CLegacyTimingDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AqI3CDemo.h"
#include "cSetI3CLegacyTimingDlg.h"
#include "afxdialogex.h"


// cSetI3CLegacyTimingDlg dialog

IMPLEMENT_DYNAMIC(cSetI3CLegacyTimingDlg, CDialog)

cSetI3CLegacyTimingDlg::cSetI3CLegacyTimingDlg(__int64 i64Timing[30], CWnd* pParent /*=NULL*/)
	: CDialog(cSetI3CLegacyTimingDlg::IDD, pParent)
{
	for (int i = 0; i < 30; i++)
		m_i64Timing[i] = i64Timing[i];
	
}

cSetI3CLegacyTimingDlg::~cSetI3CLegacyTimingDlg()
{
}

void cSetI3CLegacyTimingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(cSetI3CLegacyTimingDlg, CDialog)
	ON_BN_CLICKED(IDOK, &cSetI3CLegacyTimingDlg::OnBnClickedOk)
	ON_BN_CLICKED(ID_BN_DEFAULT, &cSetI3CLegacyTimingDlg::OnBnClickedBnDefault)
	ON_BN_CLICKED(IDCANCEL, &cSetI3CLegacyTimingDlg::OnBnClickedCancel)
	ON_CBN_SELCHANGE(IDC_CB_LEGACY_TIMING, &cSetI3CLegacyTimingDlg::OnCbnSelchangeCbLegacyTiming)
END_MESSAGE_MAP()


// cSetI3CLegacyTimingDlg message handlers
char* pStrLegacyMode[]  = {"400KHz/Fm", "1MHz/Fm+", NULL};

const int kTimingEditIDs[30] = {
	IDC_ED_0, IDC_ED_1, IDC_ED_2, IDC_ED_3, IDC_ED_4,
	IDC_ED_5, IDC_ED_6, IDC_ED_7, IDC_ED_8, IDC_ED_9,
	IDC_ED_10, IDC_ED_11, IDC_ED_12, IDC_ED_13, IDC_ED_14,
	IDC_ED_15, IDC_ED_16, IDC_ED_17, IDC_ED_18, IDC_ED_19,
	IDC_ED_20, IDC_ED_21, IDC_ED_22, IDC_ED_23, IDC_ED_24,
	IDC_ED_25, IDC_ED_26, IDC_ED_27, IDC_ED_28, IDC_ED_29
};

BOOL cSetI3CLegacyTimingDlg::OnInitDialog()
{
	CDialog::OnInitDialog();


	UpdataUI();
	return TRUE;
}


void cSetI3CLegacyTimingDlg::UpdataUI()
{
	char szBuf[64] = {0};

	for (int i = 0; i < 30; ++i)
	{
		sprintf_s(szBuf, "%lld", m_i64Timing[i]); // 假设m_i64Timing是__int64数组
		CWnd* pEdit = GetDlgItem(kTimingEditIDs[i]);
		if (pEdit)
			pEdit->SetWindowTextA(szBuf);
	}
}


void cSetI3CLegacyTimingDlg::SaveSettings()
{
	char szBuf[64] = { 0 };
	for (int i = 0; i < 30; ++i)
	{
		CWnd* pEdit = GetDlgItem(kTimingEditIDs[i]);
		if (pEdit)
		{
			pEdit->GetWindowTextA(szBuf, sizeof(szBuf));
			m_i64Timing[i] = _atoi64(szBuf); // 转成__int64类型
		}
	}
}


void cSetI3CLegacyTimingDlg::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
	SaveSettings();
	CDialog::OnOK();
}


void cSetI3CLegacyTimingDlg::OnBnClickedBnDefault()
{
	// TODO: Add your control notification handler code here
	//m_pdgI3CTimingParam->bLegacyMode = m_cbLegacyModeTiming.GetCurSel();
	//SetDefultTiming(m_pdgI3CTimingParam->bLegacyMode);
	UpdataUI();

}


void cSetI3CLegacyTimingDlg::OnBnClickedCancel()
{
	// TODO: Add your control notification handler code here
	CDialog::OnCancel();
}


void cSetI3CLegacyTimingDlg::OnCbnSelchangeCbLegacyTiming()
{
	// TODO: Add your control notification handler code here
	UpdataUI();
}


void cSetI3CLegacyTimingDlg::SetDefultTiming(BYTE bLegacyMode)
{
	//if(m_pdgI3CTimingParam->bLegacyMode == LEGACY_MODE_400KHZ)
	//{
	//	m_pdgI3CTimingParam->tSU_STA = 600;  // 600 ns
	//	m_pdgI3CTimingParam->tHD_STA =  600;
	//	m_pdgI3CTimingParam->tHigh = 1250;
	//	m_pdgI3CTimingParam->tLow = 1250;
	//	m_pdgI3CTimingParam->tSU_DAT = 100;
	//	m_pdgI3CTimingParam->tHD_DAT = 1150;
	//	m_pdgI3CTimingParam->tSU_STO = 600;
	//	m_pdgI3CTimingParam->tBuf = 1300;
	//}
	//else
	//{ // LEGACY_MODE_1MHZ
	//	m_pdgI3CTimingParam->tSU_STA = 260;
	//	m_pdgI3CTimingParam->tHD_STA = 260;
	//	m_pdgI3CTimingParam->tHigh = 500;
	//	m_pdgI3CTimingParam->tLow = 500;
	//	m_pdgI3CTimingParam->tSU_DAT = 50;
	//	m_pdgI3CTimingParam->tHD_DAT = 450;
	//	m_pdgI3CTimingParam->tSU_STO = 260;
	//	m_pdgI3CTimingParam->tBuf = 500;


	//}

}


