﻿// cSetI3CTimingDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AqI3CDemo.h"
#include "cSetI3CTimingDlg.h"
#include "afxdialogex.h"


// cSetI3CTimingDlg dialog

IMPLEMENT_DYNAMIC(cSetI3CTimingDlg, CDialog)

cSetI3CTimingDlg::cSetI3CTimingDlg(__int64 i64Timing[30], CWnd* pParent /*=NULL*/)
	: CDialog(cSetI3CTimingDlg::IDD, pParent)
{
	for (int i = 0; i < 30; i++)
		m_i64Timing[i] = i64Timing[i];
}

cSetI3CTimingDlg::~cSetI3CTimingDlg()
{
}

void cSetI3CTimingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

}


BEGIN_MESSAGE_MAP(cSetI3CTimingDlg, CDialog)
	ON_BN_CLICKED(IDOK, &cSetI3CTimingDlg::OnBnClickedOk)
	ON_BN_CLICKED(ID_BN_DEFAULT, &cSetI3CTimingDlg::OnBnClickedBnDefault)
	ON_BN_CLICKED(IDCANCEL, &cSetI3CTimingDlg::OnBnClickedCancel)
END_MESSAGE_MAP()


// cSetI3CTimingDlg message handlers
char* pStrBusType[] = {"Mixed Bus", "Pure Bus", NULL};
char* pStrTimingMode[] = {"OD_MODE", "PP_MODE", NULL};

BOOL cSetI3CTimingDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	
	UpdataUI();
	return TRUE;
}


void cSetI3CTimingDlg::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
	SaveSettings();
	CDialog::OnOK();
}


void cSetI3CTimingDlg::OnBnClickedBnDefault()
{
	// TODO: Add your control notification handler code here
	//m_pdgI3CTimingParam->bBusType = MIXED_BUS;

	UpdataUI();
}


void cSetI3CTimingDlg::OnBnClickedCancel()
{
	// TODO: Add your control notification handler code here
	CDialog::OnCancel();
}

const int kTimingEditIDs[30] = {
	IDC_ED_0, IDC_ED_1, IDC_ED_2, IDC_ED_3, IDC_ED_4,
	IDC_ED_5, IDC_ED_6, IDC_ED_7, IDC_ED_8, IDC_ED_9,
	IDC_ED_10, IDC_ED_11, IDC_ED_12, IDC_ED_13, IDC_ED_14,
	IDC_ED_15, IDC_ED_16, IDC_ED_17, IDC_ED_18, IDC_ED_19,
	IDC_ED_20, IDC_ED_21, IDC_ED_22, IDC_ED_23, IDC_ED_24,
	IDC_ED_25, IDC_ED_26, IDC_ED_27, IDC_ED_28, IDC_ED_29
};

void cSetI3CTimingDlg::UpdataUI()
{
	char szBuf[64] = { 0 };

	for (int i = 0; i < 30; ++i)
	{
		sprintf_s(szBuf, "%lld", m_i64Timing[i] / UNIT_NS); // 假设m_i64Timing是__int64数组
		CWnd* pEdit = GetDlgItem(kTimingEditIDs[i]);
		if (pEdit)
			pEdit->SetWindowTextA(szBuf);
	}
}
	

void cSetI3CTimingDlg::SaveSettings()
{
	char szBuf[64] = { 0 };
	for (int i = 0; i < 30; ++i)
	{
		CWnd* pEdit = GetDlgItem(kTimingEditIDs[i]);
		if (pEdit)
		{
			pEdit->GetWindowTextA(szBuf, sizeof(szBuf));
			m_i64Timing[i] = _atoi64(szBuf) * UNIT_NS; // 转成__int64类型
		}
	}
}


void cSetI3CTimingDlg::SetDefultTiming(BYTE bTimingMode)
{

}


