#pragma once

#define I64					__int64
#define UI64				unsigned __int64
#define itemof( A )			( sizeof(A) / sizeof(A[0]) )


// Error code about the return of dg64RunDGW/dg64RunDGV 
#define ERR_DG_FILE_NOT_FOUND		0x0001	
#define	ERR_DG_FILE_OPEN			0x0002  
#define	ERR_DG_FILE_TYPE			0x0003 
#define	ERR_DG_FILE_FORMAT			0x0004  
#define	ERR_DG_FILE_VERSION			0x0005  
#define	ERR_DG_MEMORY_NOT_ENOUGH	0x0006  
#define	ERR_DG_SIGNAL_INPUT_NAME	0x0007  
#define	ERR_DG_CHANNEL_NUMBER		0x0008  
#define	ERR_DG_TIME_STAMP			0x0009  
#define	ERR_DG_FREQ_COLLISION		0x000A  
#define	ERR_DG_NO_INPUT_NAME		0x000B  
#define	ERR_DG_DATA_LENGTH			0x000C  
#define ERR_DG_NO_TIME_MARK			0x000D  
#define ERR_DG_NO_CHANNEL_NUMBER	0x000E 
#define ERR_DG_MEMORY				0x000F  
#define ERR_DG_FILE_READ			0x0010	
#define	ERR_DG_NO_HARDWARE			0x0063  
#define ERR_DG_FREQ_NOT_MATCH		0x8001  
#define WARN_DG_DEV_MEMORY_LIMIT    0x8100 
#define WARN_DG_PC_MEMORY_LIMIT     0x8101  


typedef struct _HWINFO
{
	DWORD	dwModel;		
	char	szSerialNo[32];	
	int		iUsbSpeed;		
	int		iPods;			
	int		iChannels;		
	int		iMemDepth;		
	int		iMaxFreq;		
	int		iMinFreq;		
}HWINFO;


typedef struct _POD_INFO
{
	int		iStatus[4];			// 0=SPOD, 1=POD,BT, 2=POD, POD
	__int64	i64PodHwVer[4];
	__int64	i64PodPcbVer[4];
	char 	szPodName[4][32];	// ^PODW
}POD_INFO;

// Connect the HW
typedef bool (__stdcall *PDG64OPEN)();
//Return: true = Connected
//           false = Fail to connect

// Shut down the HW
typedef bool (__stdcall *PDG64CLOSE)();
//Return: true = Succeed


// Get the HW infomation
typedef bool (__stdcall *PDG64HWINFO)( HWINFO *hi );
//Parameter: HWINFO/HW information
//Return: true = Succeed

// Set the voltage of POD,  iPod = 0~3, iTip = 0~1, iVolt = 0(0.8V) ~ 255(5V)//
typedef bool (__stdcall *PDG64SETPODVOLT)( int iPod, int iTip, int iVolt );
//Return: true = Succeed

// Load the DGV/TDV file and run
typedef int (__stdcall *PDG64RUNDGV)( char* szFileName );
//Parameter: szFileName/DGV or TDW file
//Retrun: 0 = Succeed, Not 0 = Error Code

// Load the DGW/TDW file and run
typedef int (__stdcall *PDG64RUNDGW)( char* szFileName );
//Parameter: szFileName/DGW or TDW file
//Retrun: 0 = Succeed, Not 0 = Error Code

// Stop transmitting the waveform
typedef bool (__stdcall *PDG64STOPRUN)();
//Retrun: true = Succeed

// Get the status of device

#define UNKNOWN_STATUS -1
enum DG_STATUS_FLAG
{
    DG_SLOT_A_PLUGED = 0x0001,
    DG_SLOT_B_PLUGED = 0x0002,
    DG_SLOT_C_PLUGED = 0x0004,
    DG_SLOT_D_PLUGED = 0x0008,

    DG_SLOT_A_I2CCTRL_OK = 0x0010,
    DG_SLOT_B_I2CCTRL_OK = 0x0020,
    DG_SLOT_C_I2CCTRL_OK = 0x0040,
    DG_SLOT_D_I2CCTRL_OK = 0x0080,

    DG_SLOT_A_POWER_OK = 0x0100,
    DG_SLOT_B_POWER_OK = 0x0200,
    DG_SLOT_C_POWER_OK = 0x0400,
    DG_SLOT_D_POWER_OK = 0x0800,


	DG_WFM_END_DETECT = 0x2000,
    DG_WAITING_EXT_EVENT = 0x40000000,
    DG_WAVEFORM_SENDING = 0x80000000,
};

typedef bool (__stdcall *PDG64STATUS)( DWORD *pdwStatus );
//Parameter: pdwStatus/Return the status of device

// Get Error Code
typedef bool (__stdcall *PDG64LASTERROR)( int iBufSize, char *szBuf );
//Parameter: iBufSize/Buffer size
//Parameter: szBuf/String buffer


// DG POD Setup
typedef bool (__stdcall *PDG64PODSETUP)( POD_INFO *pi);


// Send Key Event
typedef bool (__stdcall *PDG64KEYEVENT)();