#pragma once
enum
{
	SPI_PROTOCOL = 0,
	SIPI_PROTOCOL
};

// SPI Protocol Initial
typedef HDGPTL (__stdcall *PSPI_INIT)(UINT32 iProtocolClockFreqInKHz, UINT32 iDGInitState, bool fSingleStep,
                      int* piChBuf, int iFormat, int iProtocolType, int iWordSize, bool fRepeat);

// 4-Wire SPI Packet
typedef DGADDR (__stdcall *P4WIRESPI_APPENDPACKET)(HDGPTL hDGPtl, I64 *pi64DatBuf, int iDatSize, int iSlaveRespSet);

// 3-Wire SPI Packet
typedef DGADDR (__stdcall *P3WIRESPI_APPENDPACKET)(HDGPTL hDGPtl, I64 *pi64DatBuf, int iDatSize, bool fUseWrLatencyRd,
                                  int* piBitLengBuf, int iFrameGuardTime, int iSlaveRespSet);

// 2-Wire SPI Packet
typedef DGADDR (__stdcall *P2WIRESPI_APPENDPACKET)(HDGPTL hDGPtl, I64 *pi64DatBuf, int iDatSize, bool fUseWrLatencyRd,
                                   int* piBitLengBuf, int iFrameGuardTime, int iSlaveRespSet);

// SIPI
typedef DGADDR (__stdcall *PSIPI_APPENDPACKET)(HDGPTL hDGPtl, int iType, int iClockNum, I64 i64Dat);

// Append Idle
typedef DGADDR (__stdcall *PSPI_APPENDIDLE)(HDGPTL hDGPtl, UINT32 nsecs);

// SPI Input File
typedef DGADDR (__stdcall *PSPI_INPUTFILE)(HDGPTL hDGPtl, char* pPtrFile, UINT32 nsecs);

// SIPI Input File
typedef DGADDR (__stdcall *PSIPI_INPUTFILE)(HDGPTL hDGPtl, char* pPtrFile);



