
// AqDGSPISDKDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AqDGSPISDK.h"
#include "AqDGSPISDKDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CAqDGSPISDKDlg dialog




CAqDGSPISDKDlg::CAqDGSPISDKDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CAqDGSPISDKDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAqDGSPISDKDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_raAllPackets, m_bnAllPackets);
	DDX_Control(pDX, IDC_raSinglePacket, m_bnSinglePacket);
	DDX_Control(pDX, IDC_BN_RUN, m_bnRun);
}

BEGIN_MESSAGE_MAP(CAqDGSPISDKDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BN_RUN, &CAqDGSPISDKDlg::OnBnClickedBnRun)
END_MESSAGE_MAP()


// CAqDGSPISDKDlg message handlers

BOOL CAqDGSPISDKDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_bnAllPackets.SetCheck(true);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAqDGSPISDKDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAqDGSPISDKDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAqDGSPISDKDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

enum
{
    SEL_4WIRE_SPI = 0,
    SEL_3WIRE_SPI,
    SEL_3WIRE_NO_CS_SPI,
    SEL_2WIRE_NO_CS_SPI,
    SEL_SIPI,       // 3Wire
    SEL_2WIRE_SIPI,
};

void CAqDGSPISDKDlg::OnBnClickedBnRun()
{
	// TODO: Add your control notification handler code here
	#ifdef _WIN64
		const char * szDLLName = "AqDGSPI64.dll";
#else
		const char * szDLLName = "AqDGSPI.dll";
#endif

	if( ( m_hSPISDK = LoadLibrary( szDLLName ) ) == NULL )
		return;

	m_pCloseProtocol = (PCLOSEPROTOCOL)GetProcAddress(m_hSPISDK, "CloseProtocol");
	m_pClearProtocolPacket = (PCLEARPROTOCOLPACKET)GetProcAddress(m_hSPISDK, "ClearProtocolPacket");
	m_pSaveProtocolList = (PSAVEPROTOCOLLIST)GetProcAddress(m_hSPISDK, "SaveProtocolList");
	m_pAppendDGInstruction = (PAPPENDDGINSTRUCTION)GetProcAddress(m_hSPISDK, "AppendDGInstruction");
	m_pGetLastDGError = (PGETLASTDGERROR)GetProcAddress(m_hSPISDK, "GetLastDGError");
	m_pGetPodNum = (PGETPODNUM)GetProcAddress(m_hSPISDK, "GetPodNum");
	m_pSetOutputVolt = (PSETOUTPUTVOLT)GetProcAddress(m_hSPISDK, "SetOutputVolt");
	m_pOutputProtocol = (POUTPUTPROTOCOL)GetProcAddress(m_hSPISDK, "OutputProtocol");
	m_pGetProtocolName = (PGETPROTOCOLNAME)GetProcAddress(m_hSPISDK, "GetProtocolName");
	m_pInitProtocol = (PINITPROTOCOL)GetProcAddress(m_hSPISDK, "InitProtocol");
	m_pGetDGStatus  = (PGETDGSTATUS)GetProcAddress(m_hSPISDK, "GetDGStatus");
	m_pStopDG = (PSTOPDG)GetProcAddress(m_hSPISDK, "StopDG");
	m_pShutdownDG = (PSHUTDOWNDG)GetProcAddress(m_hSPISDK, "ShutdownDG");

	m_pSPIInit = (PSPI_INIT)GetProcAddress(m_hSPISDK, "SPI_Init");
	m_pAppend4WireSPI = (P4WIRESPI_APPENDPACKET)GetProcAddress(m_hSPISDK, "_4WireSPI_AppendPacket");
	m_pAppend3WireSPI = (P3WIRESPI_APPENDPACKET)GetProcAddress(m_hSPISDK, "_3WireSPI_AppendPacket");
	m_pAppend2WireSPI = (P2WIRESPI_APPENDPACKET)GetProcAddress(m_hSPISDK, "_2WireSPI_AppendPacket");
	m_pAppendSIPI = (PSIPI_APPENDPACKET)GetProcAddress(m_hSPISDK, "SIPI_AppendPacket");
	m_pAppendIdle = (PSPI_APPENDIDLE)GetProcAddress(m_hSPISDK, "SPI_AppendIdle");
	m_pInputSPIFile = (PSPI_INPUTFILE)GetProcAddress(m_hSPISDK, "SPI_InputFile");
	m_pInputSIPIFile = (PSIPI_INPUTFILE)GetProcAddress(m_hSPISDK, "SIPI_InputFile");

	if( !( m_pInitProtocol && m_pCloseProtocol && m_pClearProtocolPacket && m_pSaveProtocolList  &&
		   m_pAppendDGInstruction && m_pGetLastDGError &&  m_pGetPodNum && m_pSetOutputVolt && 
		   m_pOutputProtocol && m_pGetProtocolName && m_pInitProtocol && m_pGetDGStatus && m_pStopDG &&
		   m_pShutdownDG && m_pSPIInit && m_pAppend4WireSPI && m_pAppend3WireSPI && m_pAppend2WireSPI &&
		   m_pAppendSIPI && m_pAppendIdle && m_pInputSPIFile && m_pInputSIPIFile) )
		return;

	if(m_bnSinglePacket.GetCheck() == BST_CHECKED)
	{
		// Single Step
		// Init DG
		// Select TD3216B model and on line mode
		m_pInitProtocol(TD3216B, true);

		int iChNoBuf[] = {0, 1, 2, 3}; 
		//int iChNoBuf[] = {1, 2, 3, -1};
		//int iChNoBuf[] = {-1, 2, 3, -1};
		//int iChNoBuf[] = {-1, 1, 2, 3};
		HDGPTL hDG = m_pSPIInit(1000, DGINIT_STATE_LOW, true, iChNoBuf, DGFMT_DGW, SPI_PROTOCOL, 8, false);

		int iErrorCode = m_pGetLastDGError();
		if(iErrorCode == ERR_MSG_NO_HARDWARE)
		{
			MessageBox("No DG!!", "SPI/SIPI SDK");
			if( m_hSPISDK )
				FreeLibrary( m_hSPISDK );
			return;
		}

		// Get the Pod number
		int iPodNums = m_pGetPodNum();

		// Set the Pod0 3.3V,  Pod0: CH0 ~ CH7
		m_pSetOutputVolt(3300, 0);
		// Set the Pod1 3.3V, Pod1: CH8 ~ CH15
		m_pSetOutputVolt(3300, 1);

		// 4-Wire SPI Packet
		I64 i64DatBuf[] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08};
		DGADDR dgAddr = m_pAppend4WireSPI(hDG, i64DatBuf, 8, SET_HIZ);

		// Clear the SPI/SIPI packet list
		m_pClearProtocolPacket(hDG);

		// Release the SPI/SIPI packet list
		m_pCloseProtocol(hDG);

		// Stop & shutdown DG
		int iStatus = m_pGetDGStatus();
		::Sleep(1000);
		if(iStatus & DG_WAVEFORM_SENDING)
			m_pStopDG();
		m_pShutdownDG();


	}
	else
	{
		// Select TD3216B model and off line mode
		m_pInitProtocol(TD3216B, true); // off line mode
		//m_pInitProtocol(DG3128B, false); // off line mode

		//int iChNoBuf[] = {0, 1, 2, -1}; // CS/SCK(SIPI-CLK)/SDI(SDA/SIPI-DATA)/SDO 
		//HDGPTL hDG = m_pSPIInit(100, DGINIT_STATE_LOW, false, iChNoBuf, DGFMT_DGW, SIPI_PROTOCOL, 0, true);
		
		int iChNoBuf[] = {0, 1, 2, 3}; 
		//int iChNoBuf[] = {1, 2, 3, -1};
		//int iChNoBuf[] = {-1, 2, 3, -1};
		//int iChNoBuf[] = {-1, 1, 2, 3};
		//Input: 1 MHz SPI protocol,  initial State: Low, Not Single Step,  Channel No. buffer, 8 bit word size, repeatedly output
		HDGPTL hDG = m_pSPIInit(1000, DGINIT_STATE_LOW, false, iChNoBuf, DGFMT_DGW, SPI_PROTOCOL, 8, true);

		// Get Protocol UID & Name
		char szPtlName[32];
		int iProtocolUID = m_pGetProtocolName(hDG, szPtlName, sizeof(szPtlName));

		// SIPI Packet
//		DGADDR dgAddr = m_pAppendSIPI(hDG, SEL_SIPI, 10, 0xF64);
		// 4-Wire SPI Packet
		I64 i64DatBuf[] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08};
		DGADDR dgAddr = m_pAppend4WireSPI(hDG, i64DatBuf, 8, SET_HIZ);
//		DGADDR dgAddr = m_pAppend3WireSPI(hDG, i64DatBuf, 8, false, NULL, 0, SET_HIZ);
		
//		int iBitLength[] = {0x08, 0x08, 0x02};
//		DGADDR dgAddr = m_pAppend3WireSPI(hDG, i64DatBuf, 8, true, iBitLength, 0, SET_HIZ);

//		DGADDR dgAddr = m_pAppend3WireSPI(hDG, i64DatBuf, 8, false, NULL, 1000, SET_HIZ);

//		DGADDR dgAddr = m_pAppend2WireSPI(hDG, i64DatBuf, 8, false, NULL, 1000, SET_HIZ);

//		DGADDR dgAddr = m_pAppend2WireSPI(hDG, i64DatBuf, 8, true, iBitLength, 1000, SET_HIZ);

//		DGADDR dgAddr = m_pInputSIPIFile(hDG, "C://Users//Edward//Documents//Acute//DG//SIPI_Data.txt");

		// 1 ms Idle
		m_pAppendIdle(hDG, 1000000);

		// SIPI Packet
//		dgAddr = m_pAppendSIPI(hDG, SEL_SIPI, 10, 0xF65);
		// 4-Wire SPI Packet
		I64 i64DatBufEx[] = {0x9, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10};
		dgAddr = m_pAppend4WireSPI(hDG, i64DatBufEx, 8, SET_HIZ);
//		dgAddr = m_pAppend3WireSPI(hDG, i64DatBufEx, 8, false, NULL, 0, SET_HIZ);
//		dgAddr = m_pAppend3WireSPI(hDG, i64DatBufEx, 8, true, iBitLength, 0, SET_HIZ);
//		dgAddr = m_pAppend3WireSPI(hDG, i64DatBufEx, 8, false, NULL, 1000, SET_HIZ);

//		dgAddr = m_pAppend2WireSPI(hDG, i64DatBufEx, 8, false, NULL, 1000, SET_HIZ);
//		dgAddr = m_pAppend2WireSPI(hDG, i64DatBuf, 8, true, iBitLength, 1000, SET_HIZ);

		// 1 ms Idle
		m_pAppendIdle(hDG, 1000000);


		// Set the Tip0 3.3V,  Tip0: CH0 ~ CH7
		m_pSetOutputVolt(3300, 0);
		// Set the Tip1 3.3V, Tip1: CH8 ~ CH15
		m_pSetOutputVolt(3300, 1);

 //   	int iFileSize = m_pSaveProtocolList(hDG, true, "SIPI_File.dgw");
		int iFileSize = m_pSaveProtocolList(hDG, true, "SPI.dgw");

		// Output  Protocol
		m_pOutputProtocol(hDG);
		
		// Clear the PMBus packet list
		m_pClearProtocolPacket(hDG);

		// Release the PMBus packet list
		m_pCloseProtocol(hDG);

		// Stop & shutdown DG
		int iStatus = m_pGetDGStatus();
		::Sleep(1000);
		if(iStatus & DG_WAVEFORM_SENDING)
			m_pStopDG();
		m_pShutdownDG();


	}

	if( m_hSPISDK )
		FreeLibrary( m_hSPISDK );

	MessageBox("Complete!", "SPI/SIPI SDK");

}
