#pragma once

#define MAX_DEVICE_ADDR_SIZE 64
#define MAX_WORD_DATA_SIZE 64
#define INVALID_DAT_VALUE   -1

typedef struct _GROUPCMDPTL
{
    UINT32 cDevAddr[MAX_DEVICE_ADDR_SIZE];
    UINT32 cCmdCode[MAX_DEVICE_ADDR_SIZE];
	UINT32 cDatSize[MAX_DEVICE_ADDR_SIZE];
    UINT32 wWordDat[MAX_WORD_DATA_SIZE];
    UINT32 iDeviceSize;
} GROUP_CMD_PTL;  // Group Command Protocol


// PMBus Protocol Initial
typedef HDGPTL (__stdcall *PPMBUS_INIT)(UINT32 iProtocolClockFreqInKHz, UINT32 iDGInitState, bool fSingleStep,
                     int iSclNo, int iSdaNo, int iFormat, bool fRepeat);

// PMBus Group Command Protocol
typedef DGADDR (__stdcall *PPMBUS_APPENDGROUPCMDPTL)(HDGPTL hDGPtl, GROUP_CMD_PTL* gcp, 
					bool fUsedPEC, int iSlaveRespSet);

// PMBus Extended Command Read Byte Protocol 
typedef DGADDR (__stdcall *PPMBUS_APPENDEXTCMDRDBYTEPTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, UINT32 cExtCmd,
                    UINT32 cCmd, bool fUsedPEC, int iSlaveRespSet);

// PMBus Extended Command Write Byte Protocol 
typedef DGADDR (__stdcall *PPMBUS_APPENDEXTCMDWRBYTEPTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, UINT32 cExtCmd,
                    UINT32 cCmd, UINT32 cDat, bool fUsedPEC, int iSlaveRespSet);

// PMBus Extended Command Read Word Protocol 
typedef DGADDR (__stdcall *PPMBUS_APPENDEXTCMDRDWORDPTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, UINT32 cExtCmd, 
					UINT32 cCmd, bool fUsedPEC, int iSlaveRespSet);

// PMBus Extended Command Write Word Protocol 
typedef DGADDR (__stdcall *PPMBUS_APPENDEXTCMDWRWORDPTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, UINT32 cExtCmd, 
	               UINT32 cCmd, UINT32 wDat, bool fUsedPEC, int iSlaveRespSet);

// PMBus ZONE_READ With STATUS DATA Response 
typedef DGADDR (__stdcall *PPMBUS_APPENDZONERDSTATDATRESP)(HDGPTL hDGPtl, UINT32 cCtlCmd, UINT32 cStatMask, 
					int iSlaveRespSet, int iPEC1, int iPEC2);

// PMBus ZONE_READ With PMBus Command 
typedef DGADDR (__stdcall *PPMBUS_APPENDZONERDPMBUSCMD)(HDGPTL hDGPtl, UINT32 cCtlCmd, UINT32 cPMBusCmd, 
					int iSlaveRespSet, int iPEC1, int iPEC2);

// PMBus ZONE_WRITE Operation With PMBus Command And Two Data Bytes 
typedef DGADDR (__stdcall *PPMBUS_APPENDZONEWRPMBUS_TWODATBYTE)(HDGPTL hDGPtl, UINT32 cPMBusCmd, 
					UINT32 wDat, int iSlaveRespSet);

// PMBus Alert Response Address
typedef DGADDR (__stdcall *PPMBUS_APPENDALERTRESPADDR)(HDGPTL hDGPtl, bool fUsedPEC, 
					int iSlaveRespSet);

// PMBus Protocol Idle 
typedef DGADDR (__stdcall *PPMBUS_APPENDIDLE)(HDGPTL hDGPtl, UINT32 usecs);

// PMBus Quick Command Protocol
typedef DGADDR (__stdcall *PPMBUS_APPENDQUICKCMDPTL)(HDGPTL hDGPtl, 
		UINT32 cSlaveAddr, UINT32 cRW, int iSlaveRespSet);

// PMBus Send Byte protocol
typedef DGADDR (__stdcall *PPMBUS_APPENDSENDBYTEPTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, 
		UINT32 cDat, bool fUsedPEC, int iSlaveRespSet);


// PMBus Receive Byte protocol
typedef DGADDR (__stdcall *PPMBUS_APPENDRECEIVEBYTEPTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, 
	bool fUsedPEC, int iSlaveRespSet);

// PMBus Write Byte Protocol
typedef DGADDR (__stdcall *PPMBUS_APPENDWRITEBYTEPTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, 
	UINT32 cCmd, UINT32 cDat, bool fUsedPEC, int iSlaveRespSet);

// PMBus Read Byte Protocol
typedef DGADDR (__stdcall *PPMBUS_APPENDREADBYTEPTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, 
	UINT32 cCmd, bool fUsedPEC, int iSlaveRespSet);

// PMBus Write Word Protocol
typedef DGADDR (__stdcall *PPMBUS_APPENDWRITEWORDPTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, UINT32 cCmd, 
	UINT32 wDat, bool fUsedPEC, int iSlaveRespSet);

// PMBus Read Word Protocol
typedef DGADDR (__stdcall *PPMBUS_APPENDREADWORDPTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, 
	UINT32 cCmd, bool fUsedPEC, int iSlaveRespSet);

// PMBus Write 32 Protocol
typedef DGADDR (__stdcall *PPMBUS_APPENDWRITE32PTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, UINT32 cCmd, 
	UINT32 dwDat, bool fUsedPEC, int iSlaveRespSet);

// PMBus Read 32 Protocol
typedef DGADDR (__stdcall *PPMBUS_APPENDREAD32PTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, UINT32 cCmd, 
	bool fUsedPEC, int iSlaveRespSet);

// PMBus Block Write Protocol
typedef DGADDR (__stdcall *PPMBUS_APPENDBLOCKWRPTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, UINT32 cCmd , UINT32 cByteCnt,
                              UINT32* pDatBuf, bool fUsedPEC, int iSlaveRespSet);

// PMBus Block Read Protocol
typedef DGADDR (__stdcall *PPMBUS_APPENDBLOCKRDPTL)(HDGPTL hDGPtl, UINT32 cSlaveAddr, UINT32 cCmd, UINT32 cByteCnt, 
	bool fUsedPEC, int iSlaveRespSet);