#pragma once

typedef unsigned int HDGPTL;
typedef unsigned int DGIDX;
typedef unsigned int UINT32;
typedef unsigned int DGADDR;

#define INVALID_HDGPTL 0xffffffff

#define DGFMT_DGW 0x0001
#define DGFMT_DGV 0x0002

enum DG_HW_MODEL
{
    DG3064B = 0x33064,
    DG3096B = 0x33096,
    DG3128B = 0x33128,

    TD3008E = 0x23008,
    TD3116B = 0x23116,
    TD3216B = 0x23216,
};

enum
{
    NOT_SET_HIZ = 0,
    SET_HIZ
};


// Error Code
#define ERR_MSG_FILE_NOT_FOUND						0x0001 
#define ERR_MSG_CANT_FIND_DLL						0x1001 
#define ERR_MSG_EMPTY_SLOT								0x1002 
#define ERR_MSG_NO_HARDWARE						0x1004 
#define ERR_MSG_INVALID_WORK_FREQ				0x1005 
#define ERR_MSG_DUPLICATED_CH_NO				0x1006 
#define ERR_MSG_CONFLICTED_HIZ_CH_NO		0x1007 
#define ERR_MSG_INVALID_STATUS						0x1008 
#define ERR_MSG_NOT_UNDER_CAPTURE			0x1009 
#define ERR_MSG_NONEXISTENT_HANDLE			0x100A 
#define ERR_MSG_INVALID_IDLE_TIME					0x100B 
#define ERR_MSG_OVER_DATA_BUFF_SIZE			0x100C 
 
// Status
#define DG_WAVEFORM_SENDING		0x80000000

// DG Instructions
#define CMD_NP		0
#define CMD_LC		1
#define CMD_LP		2
#define CMD_JP		3
#define CMD_RP		4
#define CMD_WE	5
#define CMD_NA		6 //not available
#define CMD_HD    7


enum{
			DGINIT_STATE_LOW = 0,
			DGINIT_STATE_HIGH,
			DGINIT_STATE_HI_Z,
};


////Dynamic link

//Initial / Shutdown / Error Code /
typedef bool (__stdcall *PINITPROTOCOL)(int iDGModel, bool fConnect);
typedef bool (__stdcall *PSHUTDOWNDG)();
typedef int (__stdcall *PGETLASTDGERROR)();

//Query Info
typedef int (__stdcall *PGETDGSTATUS)();
typedef int (__stdcall *PGETPODNUM)();
typedef int (__stdcall *PGETPROTOCOLNAME)(HDGPTL hDGPtl, char* pBuf, int iBufSize);

// Set Output Voltage
typedef bool (__stdcall *PSETOUTPUTVOLT)(int imV, int iPodIndex);

// Clear  / Close  Protocol
typedef bool (__stdcall *PCLEARPROTOCOLPACKET)(HDGPTL hDGPtl);
typedef bool (__stdcall *PCLOSEPROTOCOL)(HDGPTL hDGPtl);

// Output / Stop
typedef bool (__stdcall *POUTPUTPROTOCOL)(HDGPTL hDGPtl);
typedef bool (__stdcall *PSTOPDG)();

// Save File
typedef int (__stdcall *PSAVEPROTOCOLLIST)(HDGPTL hDGPtl, bool fFile, char* pPtr);

// Append DG Instruction
typedef bool (__stdcall *PAPPENDDGINSTRUCTION)(HDGPTL hDGPtl, int iInst, int iParam, DGADDR iDGAddr);



