#pragma once

enum DG_HW_MODEL
{
    DG3064B = 0x33064,
    DG3096B = 0x33096,
    DG3128B = 0x33128,

    TD3008E = 0x23008,
    TD3116B = 0x23116,
    TD3216B = 0x23216,
};

// Error Code
#define ERR_MSG_FILE_NOT_FOUND						0x0001 
#define ERR_MSG_CANT_FIND_DLL						0x1001 
#define ERR_MSG_EMPTY_SLOT								0x1002 
#define ERR_MSG_NO_HARDWARE						0x1004 
#define ERR_MSG_INVALID_WORK_FREQ				0x1005 
#define ERR_MSG_DUPLICATED_CH_NO				0x1006 
#define ERR_MSG_CONFLICTED_HIZ_CH_NO		0x1007 
#define ERR_MSG_INVALID_STATUS						0x1008 
#define ERR_MSG_NOT_UNDER_CAPTURE			0x1009 
#define ERR_MSG_NONEXISTENT_HANDLE			0x100A 
#define ERR_MSG_INVALID_IDLE_TIME					0x100B 
#define ERR_MSG_OVER_DATA_BUFF_SIZE			0x100C 
 
// Status
#define DG_WAVEFORM_SENDING		0x80000000

////Dynamic link

//Initial / Shutdown / Error Code /
typedef bool (__stdcall *PINITDG)(int iDGModel, bool fConnect);
typedef bool (__stdcall *PSHUTDOWNDG)();
typedef int (__stdcall *PGETLASTDGERROR)();

//Query Info
typedef int (__stdcall *PGETDGSTATUS)();
typedef int (__stdcall *PGETPODNUM)();

// Set Output Voltage
typedef bool (__stdcall *PSETOUTPUTVOLT)(int imV, int iPodIndex);

// Output / Stop
typedef bool (__stdcall *PDGOUTPUT)(char* pFilePath);
typedef bool (__stdcall *PSTOPDG)();

// Convert VCD File & Run
typedef int (__stdcall *PCVTVCD2DGW)(char* pFilePath);

