
// AqDGVCDCvtSDKDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AqDGVCDCvtSDK.h"
#include "AqDGVCDCvtSDKDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CAqDGVCDCvtSDKDlg dialog




CAqDGVCDCvtSDKDlg::CAqDGVCDCvtSDKDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CAqDGVCDCvtSDKDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAqDGVCDCvtSDKDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BROWSE, m_bnBrowse);
	DDX_Control(pDX, IDC_RUN, m_bnRun);
	DDX_Control(pDX, IDC_VCD_FILEPATH, m_stVcdFilePath);
}

BEGIN_MESSAGE_MAP(CAqDGVCDCvtSDKDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BROWSE, &CAqDGVCDCvtSDKDlg::OnBnClickedBrowse)
	ON_BN_CLICKED(IDC_RUN, &CAqDGVCDCvtSDKDlg::OnBnClickedRun)
END_MESSAGE_MAP()


// CAqDGVCDCvtSDKDlg message handlers

BOOL CAqDGVCDCvtSDKDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_sFilePath.Empty();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAqDGVCDCvtSDKDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAqDGVCDCvtSDKDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAqDGVCDCvtSDKDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CAqDGVCDCvtSDKDlg::OnBnClickedBrowse()
{
	// TODO: Add your control notification handler code here
	const TCHAR szFilter[] = _T("VCD Files (*.VCD)|*.VCD|All Files (*.*)|*.*||");
	CFileDialog dlg(TRUE, _T("VCD"), NULL,OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST |
												OFN_EXPLORER | OFN_HIDEREADONLY, szFilter, this);    
	if(dlg.DoModal() == IDOK)
	{
		m_sFilePath = dlg.GetPathName();
		m_stVcdFilePath.SetWindowText(m_sFilePath);
	}
}


void CAqDGVCDCvtSDKDlg::OnBnClickedRun()
{
	// TODO: Add your control notification handler code here
#ifdef _WIN64
		const char * szDLLName = "AqDGVCDCvt64.dll";
#else
		const char * szDLLName = "AqDGVCDCvt.dll";
#endif

	if( ( m_hVCDCvt = LoadLibrary( szDLLName ) ) == NULL )
		return;

	m_pGetLastDGError = (PGETLASTDGERROR)GetProcAddress(m_hVCDCvt, "GetLastDGError");
	m_pGetPodNum = (PGETPODNUM)GetProcAddress(m_hVCDCvt, "GetPodNum");
	m_pSetOutputVolt = (PSETOUTPUTVOLT)GetProcAddress(m_hVCDCvt, "SetOutputVolt");
	m_pDGOutput = (PDGOUTPUT)GetProcAddress(m_hVCDCvt, "DGOutput");
	m_pInitDG = (PINITDG)GetProcAddress(m_hVCDCvt, "InitDG");
	m_pGetDGStatus  = (PGETDGSTATUS)GetProcAddress(m_hVCDCvt, "GetDGStatus");
	m_pStopDG = (PSTOPDG)GetProcAddress(m_hVCDCvt, "StopDG");
	m_pShutdownDG = (PSHUTDOWNDG)GetProcAddress(m_hVCDCvt, "ShutdownDG");
	m_pCvtVcd2Dgw = (PCVTVCD2DGW)GetProcAddress(m_hVCDCvt, "CvtVcd2Dgw");
		
	if( !( m_pInitDG && m_pGetLastDGError &&  m_pGetPodNum && m_pSetOutputVolt && 
			m_pDGOutput && m_pGetDGStatus && m_pStopDG && m_pShutdownDG && m_pCvtVcd2Dgw ) )
		return;

	// Select TD3216B model and on line mode
	m_pInitDG(TD3216B, true);
//	m_pInitDG(TD3216B, false); // Only convert VCD to DGW

	int iErrorCode = m_pGetLastDGError();
	if(iErrorCode == ERR_MSG_NO_HARDWARE)
		MessageBox("No DG Hardware, Convert the VCD File Only!!", "VCDCvt SDK");
		
	// Get the numbers of Pod
	int iPodNums = m_pGetPodNum();
	// Set the Pod0 3.3V,  Pod0: CH0 ~ CH7
	m_pSetOutputVolt(3300, 0);
	// Set the Pod1 3.3V, Pod1: CH8 ~ CH15
	m_pSetOutputVolt(3300, 1);

	if(!m_sFilePath.IsEmpty())
		m_pCvtVcd2Dgw(m_sFilePath.GetBuffer(m_sFilePath.GetLength()));

	// Output 
	m_pDGOutput(NULL); //default file 
	//m_pDGOutput("D:\\WorkProject\\DG_Protocol_dll_Qt\\DG_VCDCvt_SDK_Sample\\AqDGVCDCvtSDK\\I2C.DGW");
	Sleep(1000); // delay 1 s

	// Stop & shutdown DG
	int iStatus = m_pGetDGStatus();

	if(iStatus & DG_WAVEFORM_SENDING)
		m_pStopDG();
	m_pShutdownDG();

	if( m_hVCDCvt )
		FreeLibrary( m_hVCDCvt );
	
	MessageBox("Complete!", "VCDCvt SDK");
}
