﻿

#include "afxwin.h"
//#define HDGPTL UINT32
#define DGADDR __int64
#define BYTE unsigned char
#define HDGPTL UINT32

//#define SPI 1

//enum DG_HW_MODEL
//{
//    DG3064B = 0x33064,
//    DG3096B = 0x33096,
//    DG3128B = 0x33128,
//
//    TD3008E = 0x23008,
//    TD3116B = 0x23116,
//    TD3216B = 0x23216,
//};

// For DG
#define ERR_DG_SDK_HW_NOT_FOUND 1 //找不到 DG 硬體
#define ERR_DG_SDK_VOLT_OUT_OF_RANGE 2 //輸出電壓超出範圍
#define ERR_DG_SDK_INVALID_VOLT_GRP_IDX 3 //Voltage group index 超出範圍
#define ERR_DG_SDK_INVALID_INSTRUCTION 4 //錯誤的 DG 指令
#define ERR_DG_SDK_INVALID_PARAMETER 5 //錯誤的 DG 指令參數
#define ERR_DG_SDK_INVALID_DG_ADDRESS 6 //錯誤的 DG 指令安插位置
#define ERR_DG_PTL_INVALID_DGRUN_DLL_RESOLVE 7 //錯誤的 DGRUN DLL 引用
#define ERR_DG_PTL_INVALID_DGSDK_DLL_RESOLVE 8 //錯誤的 DGSDK DLL 引用


// For Protocol
#define ERR_DG_PTL_INVALID_HANDLE 700 //錯誤的 Handle
#define ERR_DG_PTL_INVALID_FILE_NAME 701 //錯誤的檔案名稱
#define ERR_DG_PTL_INVALID_FILE_TYPE 702 // 錯誤的檔案型態
#define ERR_DG_PTL_INVALID_FINDING_DLL  703 // 錯誤的Protocol DLL尋找過程
#define ERR_DG_PTL_INVALID_BUFF_OVERFLOW 704 // Buffer over flow
#define ERR_DG_PTL_INVALID_CHANNEL_NO 705 //重複使用通道編號

// For SVID
#define ERR_DG_SVID_INVALID_CHANNEL_NO 1000 //錯誤的 SVID 通道編號
#define ERR_DG_SVID_INVALID_FREQUENCY 1001 //錯誤的 SVID 輸出頻率
#define ERR_DG_SVID_INVALID_FRAME_RANGE 1002 //錯誤的 SVID 封包欄位範圍
#define ERR_DG_SVID_INVALID_APPEND_PKT_MODE 1003 //錯誤的 SVID 模式
#define ERR_DG_SVID_INVALID_APPEND_PKT_MODE_PARAM 1004 //錯誤的 SVID 模式參數
#define ERR_DG_SVID_INVALID_DELAY 1005 //錯誤的 SVID Delay 時間
#define ERR_DG_SVID_INVALID_IDLE_STATE 1006 //錯誤的 IDLE State

// For SPI
#define ERR_DG_SPI_INVALID_CHANNEL_NO 2000 //錯誤的 SPI 通道編號
#define ERR_DG_SPI_INVALID_FREQUENCY 2001 //錯誤的 SPI 輸出頻率
#define ERR_DG_SPI_INVALID_BUS_WIDTH 2002 //錯誤的 SPI Bus Width
#define ERR_DG_SPI_INVALID_LATCH_MODE 2003 //錯誤的 SPI Latch模式

typedef struct _SDK_ERROR
{
	UINT32	iErrorCode;
	CString csError;

}SDK_ERROR;





// Error Code
#define ERR_MSG_FILE_NOT_FOUND						0x0001 
#define ERR_MSG_CANT_FIND_DLL						0x1001 
#define ERR_MSG_EMPTY_SLOT								0x1002 
#define ERR_MSG_NO_HARDWARE						0x1004 
#define ERR_MSG_INVALID_WORK_FREQ				0x1005 
#define ERR_MSG_DUPLICATED_CH_NO				0x1006 
#define ERR_MSG_CONFLICTED_HIZ_CH_NO		0x1007 
#define ERR_MSG_INVALID_STATUS						0x1008 
#define ERR_MSG_NOT_UNDER_CAPTURE			0x1009 
#define ERR_MSG_NONEXISTENT_HANDLE			0x100A 
#define ERR_MSG_INVALID_IDLE_TIME					0x100B 
#define ERR_MSG_OVER_DATA_BUFF_SIZE			0x100C 

// Status
#define DG_WAVEFORM_SENDING		0x80000000

////Dynamic link

typedef HDGPTL (__stdcall *PINITPROTOCOLSDK)();
typedef HDGPTL (__stdcall *PGETHDGPTL)();//GethDGPtl();
typedef bool (__stdcall *PCLOSEPROTOCOLSDK)();
typedef UINT32 (__stdcall *PGETVOLTGRPNUM)();
typedef bool (__stdcall *PSETOUTPUTVOLT)(UINT32 imV, UINT32 iPodIndex);
typedef UINT32 (__stdcall *PGETLASTDGERROR)();
typedef bool (__stdcall *PCLEARALLPATTERN)();
typedef bool (__stdcall *PCLEARPATTERNBYORDER)(int iIdx);
typedef bool (__stdcall *PCLEARPATTERN)();
typedef bool (__stdcall *PMERGE)(HDGPTL hDGPtl[], UINT32 hDGPtlSize);
typedef bool (__stdcall *PSAVEPATTERN)(char* pStrFileName, UINT32 iFileType);
typedef bool (__stdcall *PAPPENDDGINSTRUCTION)(DGADDR iDGAddr, UINT32 iInst, UINT32 iParam);
typedef bool (__stdcall *POUTPUTPACKETLIST)(bool fOutput);
typedef bool (__stdcall *PADJPHASE)(UINT32 iCh, int iDelay);
typedef bool (__stdcall *PISTD)();


typedef bool(__stdcall *PI3C_SETTINGS)(HDGPTL hDGPtl, UINT32 iSCL, UINT32 iSDA[4], UINT32 iFreq, UINT32 iFreq2, __int64 i64timing[30]);

typedef DGADDR(__stdcall* PI3C_START)(HDGPTL hDGPtl, DGADDR i64CurrIdx, bool fRepeatStart);
typedef DGADDR(__stdcall* PI3C_SDR)(HDGPTL hDGPtl, DGADDR i64CurrIdx, int iType, UINT8 ui8Data, bool fHiZ);
typedef DGADDR(__stdcall* PI3C_HDR)(HDGPTL hDGPtl, DGADDR i64CurrIdx, int iType, UINT8 ui8Data, bool fHiZ);
typedef DGADDR(__stdcall* PI3C_TSX)(HDGPTL hDGPtl, DGADDR i64CurrIdx, int iType, UINT16 ui16Data, bool fHiZ);
typedef DGADDR(__stdcall* PI3C_STOP)(HDGPTL hDGPtl, DGADDR i64CurrIdx);
typedef DGADDR(__stdcall* PI3C_IDLE)(HDGPTL hDGPtl, DGADDR i64CurrIdx, __int64 i64IdleTime);



typedef UINT32 (__stdcall *PFINDDEV)();


class AqDGI3C
{

public:
	AqDGI3C();
	~AqDGI3C();

	HDGPTL InitProtocol();
	bool CloseProtocol();
	HDGPTL GethDGPtl();
	UINT32 GetVoltGrpNum();
	bool SetOutputVolt(UINT32 imV, UINT32 iVoltGrpIdx);
	UINT32 GetLastErrorEx();
	bool ClearAllPattern();
	bool ClearPatternByOrder(int iIdx);
	bool ClearPattern();
	bool Merge(HDGPTL hDGPtl[], UINT32 hDGPtlSize);
	UINT32 SavePattern(char* pStrFileName, UINT32 iFileType);
	bool AppendDGInstruction(DGADDR iDGAddr, UINT32 iInst, UINT32 iParam);
	bool OutputPacketList(bool fOutput);
	int AdjustPhase(int iCh, int iDelay);

	bool I3C_Settings(HDGPTL hDGPtl, UINT32 iSCL, UINT32 iSDA[4], UINT32 iFreq, UINT32 iFreq2, __int64 i64timing[30]);
	bool SetI2CLegacyTiming(HDGPTL hDGPtl, __int64 tSU_STA, __int64 tHD_STA, __int64 tHIGH, __int64 tLOW, __int64 tSU_DAT, __int64 tSU_STO, __int64 tBUF);
	bool SetODTiming(HDGPTL hDGPtl, __int64 tHIGH_OD, __int64 tLOW_OD, __int64 tSU_OD, __int64 tCAS_OD, __int64 tCBP_OD);
	bool SetPPTiming(HDGPTL hDGPtl, __int64 tLOW_PP, __int64 tSU_PP, __int64 tCASr_PP, __int64 tCBSr_PP);
	DGADDR I3C_Start(HDGPTL hDGPtl, DGADDR i64CurrIdx, bool fRepeatStart);
	DGADDR I3C_SDR(HDGPTL hDGPtl, DGADDR i64CurrIdx, int iType, UINT8 ui8Data, bool fHiZ);
	DGADDR I3C_HDR(HDGPTL hDGPtl, DGADDR i64CurrIdx, int iType, UINT8 ui8Data, bool fHiZ);
	DGADDR I3C_TSX(HDGPTL hDGPtl, DGADDR i64CurrIdx, int iType, UINT16 ui16Data, bool fHiZ);
	DGADDR I3C_Stop(HDGPTL hDGPtl, DGADDR i64CurrIdx);
	DGADDR I3C_Idle(HDGPTL hDGPtl, DGADDR i64CurrIdx, __int64 i64IdleTime);

	bool IsTD();

	UINT32 FindDev();

private:

	HINSTANCE m_hI3CCvt;

	PINITPROTOCOLSDK pInitProtocol;
	PCLOSEPROTOCOLSDK pCloseProtocol;
	PGETHDGPTL pGethDGPtl;
	PGETVOLTGRPNUM pGetVoltGrpNum;
	PSETOUTPUTVOLT pSetOutputVolt;
	PGETLASTDGERROR pGetLastErrorEx;
	PCLEARALLPATTERN pClearAllPattern;
	PCLEARPATTERNBYORDER pClearPatternByOrder;
	PCLEARPATTERN pClearPattern;
	PMERGE pMerge;	
	PSAVEPATTERN pSavePattern;
	PAPPENDDGINSTRUCTION pAppendDGInstruction;
	POUTPUTPACKETLIST pOutputPacketList;
	PADJPHASE pAdjustPhase;
	PISTD pIsTD;

	PI3C_SETTINGS pI3C_Settings;

	PI3C_START pI3C_Start;
	PI3C_SDR pI3C_SDR;
	PI3C_HDR pI3C_HDR;
	PI3C_TSX pI3C_TSX;
	PI3C_STOP pI3C_Stop;
	PI3C_IDLE pI3C_Idle;
	
	PFINDDEV pFindDev;

};