
// AqI3CDemoDlg.h : header file
//

#pragma once
#include "afxwin.h"
#include "afxcmn.h"
#include "AqDGSDKPTL_API.h"

enum DGPTL_HWINFO_MODEL
{
    MODEL_DG4128B = 0x4004312A,
    MODEL_DG4096B = 0x4004309A,
    MODEL_DG4064B = 0x4004306A,
    MODEL_DG3112B = 0x30003112,
    MODEL_DG3080B = 0x30003080,
    MODEL_DG3048B = 0x30003048,
    MODEL_DG3128B = 0x30003128,
    MODEL_DG3096B = 0x30003096,
    MODEL_DG3064B = 0x30003064,
    MODEL_TD3216B = 0x20003216,
    MODEL_TD3116B = 0x20003116,
    MODEL_TD3008E = 0x20003008,

	MODEL_MASK = 0xF0000,
	MODEL_TD3K_SERIES = 0x20000,
	MODEL_DG3K_SERIES = 0x30000,


};

typedef struct
{
	UINT32 iModel;
	char szModel[32];

} DG_HW_INFO;

enum
{
    MIXED_BUS = 0,
    PURE_BUS,
};

enum
{
    OD_MODE = 0,
    PP_MODE,
};

enum
{
    LEGACY_MODE_400KHZ = 0,
    LEGACY_MODE_1MHZ,
};

enum
{
    I3C_HIZ = -1,
    I3C_WR = 0,
    I3C_RD,

};

enum
{
	FREQ_KHZ_UNIT = 0,
	FREQ_MHZ_UNIT,
};


#define tDIG_H_OD_MIXED_BUS 200
#define tDIG_H_OD_PURE_BUS 35

enum
{
	Legacy_I2C_Transfer_Without_ResevByte = 0,
	Legacy_I2C_Wr_Transfer_With_ResevByte, 
	Legacy_I2C_Rd_Transfer_With_ResevByte,
	I3C_Private_Write,
	I3C_Private_Read,
	I3C_Broadcast_CCC_Write,
	I3C_Directed_CCC_Write,
	I3C_Directed_CCC_Read,
	I3C_ENTDAA_CCC_Format,
	I3C_Enter_HDR_DDR_Mode_Format,
	
};

#define SAMPLE_UNIT 1000 // 5 ns DG resolution
#define MAX_VOLT_GROUP_SIZE 8
typedef struct 
{

	int tSU_STA; 
    int tHD_STA;
    int tHigh;
    int tLow;
    int tSU_DAT;
    int tHD_DAT;
    int tSU_STO;
    int tRes7;
    int tRes8;
    int tBuf;

	//OD
	int tLow_OD;
    int tHIGH;
	int tSU_OD;
        int tHD_OD;
    int tCAS;
    int tCBP;
    int tRes6_OD;
    int tRes7_OD;
    int tRes8_OD;
    int tIDLE_OD;

	//PP
	int tLow_PP;
    int tHIGH_PP;
    int tSCO_PP;
    int tRes3_PP;
    int tSU_PP;
    int tHD_PP;
    int tCASr;
    int tCBSr;
    int tRes_PP;
    int tIDLE_PP;


} DG_I3C_TIMING_PARAM;

enum
{
    IDX_tSU_STA_L = 0,
    IDX_tHD_STA_L,
    IDX_tLOW_L,
    IDX_tHIGH_L,
    IDX_tSU_DAT_L,
    IDX_tHD_DAT_L,
    IDX_tSU_STO_L,
    IDX_tRes7_L,
    IDX_tRes8_L,
    IDX_tBUF_L,

    // OD-10
    IDX_tLOW_OD,
    IDX_tHIGH_OD,
    IDX_tSU_OD,
    IDX_tHD_OD,
    IDX_tCAS_OD,
    IDX_tCBP_OD,
    IDX_tRes6_OD,
    IDX_tRes7_OD,
    IDX_tRes8_OD,
    IDX_tIDLE_OD,

    // PP-10
    IDX_tLOW_PP,
    IDX_tHIGH_PP,
    IDX_tSCO_PP,
    IDX_tRes3_PP,
    IDX_tSU_PP,
    IDX_tHD_PP,
    IDX_tCASr_PP,
    IDX_tCBSr_PP,
    IDX_tRes8_PP,
    IDX_tIDLE_PP,

    IDX_TIMING_TOTAL
};


#define INVALID_HANDLE	0
// CAqI3CDemoDlg dialog
class CAqI3CDemoDlg : public CDialogEx
{
// Construction
public:
	CAqI3CDemoDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_AQI3CDEMO_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	DECLARE_MESSAGE_MAP()
public:
	CComboBox m_cbCommFormat;
	CSpinButtonCtrl m_spDGSCL;
	CStatic m_stDGSCL;
	CSpinButtonCtrl m_spDGSDA;
	CStatic m_stDGSDA;
	CButton m_bnAcTiming;
	CButton m_bnFreqUnit;
	CSpinButtonCtrl m_spFreq;
	CButton m_bnFreqUnit2;
	CSpinButtonCtrl m_spFreq2;
	CStatic m_stDesc;
	CEdit m_edFreq;
	CEdit m_edFreq2;
	CFont m_font;

	int m_iFreqUnit;
	int m_iFreqUnit2;
	static int m_iFreqVal[];
	DG_I3C_TIMING_PARAM m_dgI3CTimingParams;
	static DG_HW_INFO m_dgHwInfo[];
        __int64 m_i64Timing[IDX_TIMING_TOTAL];

	void UpdateSpin2Edit(void);
	void UpdateSpin2Edit(CStatic* pstCh, int iVal);
	void UpdateSpin2EditEx(CEdit* pedFreq, int iVal);
	void GeneI3CFormat(int iSelect);



	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnBnClickedBnDgFreq();
	afx_msg void OnBnClickedBnDgFreq2();
	afx_msg void OnEnChangeEdDgFreq();
	afx_msg void OnEnChangeEdDgFreq2();
	afx_msg void OnCbnSelchangeCbDgCommfomat();
	afx_msg void OnBnClickedBnDgActiming();
	afx_msg void OnBnClickedBnGethw();
	afx_msg void OnBnClickedBnRun();
	afx_msg void OnBnClickedBnStop();

    void DefaultTiming();
    void ChkTiming();

	bool m_fDGConn;
	bool m_fLAConn;

	UINT32 m_handle;
	AqDGI3C m_DGI3C;

	CButton m_bnGetHW;
	CButton m_bnRun;
	CButton m_bnStop;
	CStatic m_stDGModel;
	CComboBox m_cbOutputLvl;
    afx_msg void OnDeltaposSpDgFreq(NMHDR* pNMHDR, LRESULT* pResult);
    afx_msg void OnBnClickedBnDefault();
};
