
// DG_VC_SDKDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DG_VC_SDK.h"
#include "DG_VC_SDKDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CDG_VC_SDKDlg dialog




CDG_VC_SDKDlg::CDG_VC_SDKDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CDG_VC_SDKDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDG_VC_SDKDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MODEL, m_edModelName);
	DDX_Control(pDX, IDC_FILENAME, m_edFileName);
	DDX_Control(pDX, IDC_BROWSE, m_bnBrowse);
	DDX_Control(pDX, IDC_GETHARDWARE, m_bnGetHW);
	DDX_Control(pDX, IDC_START, m_bnStart);
	DDX_Control(pDX, IDC_STOP, m_bnStop);
	DDX_Control(pDX, IDC_SHUTDOWN, m_bnShutdown);
}

BEGIN_MESSAGE_MAP(CDG_VC_SDKDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BROWSE, &CDG_VC_SDKDlg::OnBnClickedBrowse)
	ON_BN_CLICKED(IDC_GETHARDWARE, &CDG_VC_SDKDlg::OnBnClickedGethardware)
	ON_BN_CLICKED(IDC_START, &CDG_VC_SDKDlg::OnBnClickedStart)
	ON_BN_CLICKED(IDC_STOP, &CDG_VC_SDKDlg::OnBnClickedStop)
	ON_BN_CLICKED(IDC_SHUTDOWN, &CDG_VC_SDKDlg::OnBnClickedShutdown)
	ON_WM_TIMER()
	ON_WM_CLOSE()
	ON_WM_TIMER()
END_MESSAGE_MAP()


// CDG_VC_SDKDlg message handlers

BOOL CDG_VC_SDKDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
#ifdef _WIN64
	const char * szDLLName = "DgRun64.dll";
#else
	const char * szDLLName = "DgRun.dll";
#endif

	if( ( m_hDGSDK = LoadLibrary( szDLLName ) ) == NULL )
	{
		MessageBox( "Can NOT Load dll", NULL, MB_ICONERROR );
		m_bnGetHW.EnableWindow(FALSE);
	}
	else
	{
		m_pDgOpen = (PDG64OPEN)GetProcAddress(m_hDGSDK, "dg64Open");
		m_pDgClose = (PDG64CLOSE)GetProcAddress(m_hDGSDK, "dg64Close"); 
		m_pDgHwInfo = (PDG64HWINFO)GetProcAddress(m_hDGSDK, "dg64HwInfo");
		m_pDgRundgv = (PDG64RUNDGV)GetProcAddress(m_hDGSDK, "dg64RunDGV");
		m_pDgRundgw = (PDG64RUNDGW)GetProcAddress(m_hDGSDK, "dg64RunDGW");
		m_pDgStopRun = (PDG64STOPRUN)GetProcAddress(m_hDGSDK, "dg64StopRun");
		m_pDgGetStatus = (PDG64STATUS)GetProcAddress(m_hDGSDK, "dg64Status");
		m_pDgLastError = (PDG64LASTERROR)GetProcAddress(m_hDGSDK, "dg64LastError");
		m_pDg64PodSetup = (PDG64PODSETUP)GetProcAddress(m_hDGSDK, "dg64PodSetup");
		m_pDg64KeyEvent = (PDG64KEYEVENT)GetProcAddress(m_hDGSDK, "dg64KeyEvent");

	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDG_VC_SDKDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDG_VC_SDKDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CDG_VC_SDKDlg::OnBnClickedBrowse()
{
	// TODO: Add your control notification handler code here
	 char	szFile[2048] = "*.dgw;*.dgv;*.tdw";		// maximum common dialog buffer size
    char	szFilter[] = "DG/TD Waveform Files(.dgw;*.dgv;*.tdw)|.dgw;*.dgv;*.tdw|All Files(*.*)|*.*||";
	CString	str;

	CFileDialog dlg( TRUE, NULL, szFile, OFN_FILEMUSTEXIST | OFN_ALLOWMULTISELECT, szFilter );

	// Modify OPENFILENAME members directly to point to szFile
	dlg.DoModal();
	str = dlg.GetPathName();
	m_edFileName.SetWindowTextA(LPCTSTR(str));
}

MODEL_INFO ModelInfo[] = 
{
	{0x33064,			"DG3064B"},
	{0x33096,			"DG3096B"},
	{0x33128,		    "DG3128B"},
	
	{0x23008,			"TD3008E"},
	{0x23116,			"TD3116B"},
	{0x23216,			"TD3216B"},

	{0x33048,			"DG3048B"},
	{0x33080,			"DG3080B"},
	{0x33112,			"DG3112B"},
	{0,						""}
};
void CDG_VC_SDKDlg::OnBnClickedGethardware()
{
	// TODO: Add your control notification handler code here
	bool IsDevExist = m_pDgOpen();
	if(IsDevExist)
	{
		HWINFO cHwInfo = {0};
		POD_INFO	pi;
   
		m_pDgHwInfo(&cHwInfo);
		m_pDg64PodSetup( &pi );
		bool IsModelIDFound = false;
		char sz[64];
		for(int i = 0; ModelInfo[i].dwModelID != 0; i++)
		{
			if(cHwInfo.dwModel == ModelInfo[i].dwModelID)
			{
				IsModelIDFound = true;
				strcpy_s(sz, _countof(sz),  ModelInfo[i].szModel);
				break;
			}
		}

		if(IsModelIDFound)
		{
			m_bnGetHW.EnableWindow(FALSE);
			m_bnStart.EnableWindow(TRUE);
			m_bnStop.EnableWindow(TRUE);
			m_bnShutdown.EnableWindow(TRUE);
			m_edModelName.SetWindowTextA(LPCTSTR(sz));
		}
		else
		{
			MessageBox( "No Hardware!" );
			return;
		}

	}
	else
	{
			MessageBox( "No Hardware!" );
			return;
	}

}

bool CDG_VC_SDKDlg::SendKeyEvent()
{
	//::Sleep(2000);

	//DWORD dwStatus = 0;
	//if(m_pDgGetStatus(&dwStatus))
	//{
	//	if(dwStatus & DG_WAITING_EXT_EVENT)
	//		return m_pDg64KeyEvent();
	//	else
	//		return false;
	//}
	//return false;

	DWORD dwStatus = 0;
	for(int i = 0; i < 10; i++)
	{
		 m_pDgGetStatus(&dwStatus);
		 if(dwStatus & DG_WAITING_EXT_EVENT)
            return m_pDg64KeyEvent();
           
		 ::Sleep(200);
	}

	m_pDgGetStatus(&dwStatus);
	if(dwStatus & DG_WAITING_EXT_EVENT)
		return m_pDg64KeyEvent();
	else
		return false;


}

#define IDT_WFM_END	0x100
void CDG_VC_SDKDlg::OnBnClickedStart()
{
	// TODO: Add your control notification handler code here
	CString strFileName, strExtFile;
	int iErrorCode = 0;

	m_edFileName.GetWindowTextA(strFileName);
	strExtFile = strFileName.Right(4);
	strExtFile.MakeUpper();

	if(strExtFile.Compare(".DGW") == 0 ||
		strExtFile.Compare(".TDW") == 0)
		iErrorCode = m_pDgRundgw(strFileName.GetBuffer(MAX_PATH));
	else
	if(strExtFile.Compare(".DGV") == 0)
		iErrorCode = m_pDgRundgv(strFileName.GetBuffer(MAX_PATH));

	switch(iErrorCode)
	{
	case 0:
		m_bnBrowse.EnableWindow(FALSE);
		m_bnStart.EnableWindow(FALSE);

		// Send Key Event
		SendKeyEvent();
		// Timer
		SetTimer(IDT_WFM_END, 100, NULL);

		break;
	case 0x0001:
		MessageBox("File not found.");
		break;
	case 0x0002:
		MessageBox("File cannot be opened.");
		break;
	case 0x0003:
		MessageBox("Unknown file type.");
		break;
	case 0x0004:
		MessageBox("File format invalid.");
		break;
	case 0x0005:
		MessageBox("File format too old.");
		break;
	case 0x0006:
		MessageBox("System memory not enough.");
		break;
	case 0x0007:
		MessageBox("Signal name duplicated.");
		break;
	case 0x0008:
		MessageBox("Too many channels.");
		break;
	case 0x0009:
		MessageBox("Timestamp error.");
		break;
	case 0x000A:
		MessageBox("Frequency Collision.");
		break;
	case 0x000B:
		MessageBox("No input channel name.");
		break;
	case 0x000C:
		MessageBox("Device memory not enough.");
		break;
	case 0x000D:
		MessageBox("No time mark.");
		break;
	case 0x000E:
		MessageBox("No input channel number.");
		break;
	case 0x000F:
		MessageBox("Insufficient memory buffer.");
		break;
	case 0x0010:
		MessageBox("File read error.");
		break;
	case 0x0063:
		MessageBox("No hardware.");
		break;
	case 0x8001:
		 if( MessageBox( "Warning: Use close frequency for system clock. Run(Y/N)", NULL, MB_YESNO ) == IDYES )
		{
			m_bnBrowse.EnableWindow(FALSE);
			m_bnStart.EnableWindow(FALSE);		
		}
		else
		{
			m_pDgStopRun();
		}
		break;
	case 0x8100:
		MessageBox("File turncated by device memory limitation.");
		break;
	case 0x8101:
		MessageBox("File turncated by PC memory limitation.");
		break;
     default:
        MessageBox("Critical Error.");
		break;

	}
	

}


void CDG_VC_SDKDlg::OnBnClickedStop()
{
	// TODO: Add your control notification handler code here
	KillTimer(IDT_WFM_END);

	m_pDgStopRun();
	m_bnBrowse.EnableWindow(TRUE);
	m_bnStart.EnableWindow(TRUE);
}


void CDG_VC_SDKDlg::OnBnClickedShutdown()
{
	// TODO: Add your control notification handler code here
	OnBnClickedStop();
	m_pDgClose();
	m_bnGetHW.EnableWindow(TRUE);
	m_bnStart.EnableWindow(FALSE);
	m_bnStop.EnableWindow(FALSE);
	m_bnShutdown.EnableWindow(FALSE);
	m_edModelName.SetWindowTextA(LPCTSTR(""));

}


void CDG_VC_SDKDlg::OnClose()
{
	// TODO: Add your message handler code here and/or call default
	if( m_hDGSDK )
		FreeLibrary( m_hDGSDK );
	CDialogEx::OnClose();
}


void CDG_VC_SDKDlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	if(nIDEvent == IDT_WFM_END)
	{
		DWORD dwStatus = 0;
		m_pDgGetStatus(&dwStatus);
		if(dwStatus & DG_WFM_END_DETECT)
			OnBnClickedStop();
	}
	CDialogEx::OnTimer(nIDEvent);
}
