
// AqDGPMBusSDKDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AqDGPMBusSDK.h"
#include "AqDGPMBusSDKDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CAqDGPMBusSDKDlg dialog




CAqDGPMBusSDKDlg::CAqDGPMBusSDKDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CAqDGPMBusSDKDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAqDGPMBusSDKDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_raAllPackets, m_bnAllPackets);
	DDX_Control(pDX, IDC_raSinglePacket, m_bnSinglePacket);
	DDX_Control(pDX, IDC_BN_RUN, m_bnRun);
}

BEGIN_MESSAGE_MAP(CAqDGPMBusSDKDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BN_RUN, &CAqDGPMBusSDKDlg::OnBnClickedBnRun)
END_MESSAGE_MAP()


// CAqDGPMBusSDKDlg message handlers

BOOL CAqDGPMBusSDKDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_bnAllPackets.SetCheck(true);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAqDGPMBusSDKDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAqDGPMBusSDKDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAqDGPMBusSDKDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CAqDGPMBusSDKDlg::OnBnClickedBnRun()
{
	// TODO: Add your control notification handler code here
#ifdef _WIN64
		const char * szDLLName = "AqDGPMBus64.dll";
#else
		const char * szDLLName = "AqDGPMBus.dll";
#endif

	if( ( m_hPMBusSDK = LoadLibrary( szDLLName ) ) == NULL )
		return;

	m_pCloseProtocol = (PCLOSEPROTOCOL)GetProcAddress(m_hPMBusSDK, "CloseProtocol");
	m_pClearProtocolPacket = (PCLEARPROTOCOLPACKET)GetProcAddress(m_hPMBusSDK, "ClearProtocolPacket");
	m_pSaveProtocolList = (PSAVEPROTOCOLLIST)GetProcAddress(m_hPMBusSDK, "SaveProtocolList");
	m_pAppendDGInstruction = (PAPPENDDGINSTRUCTION)GetProcAddress(m_hPMBusSDK, "AppendDGInstruction");
	m_pGetLastDGError = (PGETLASTDGERROR)GetProcAddress(m_hPMBusSDK, "GetLastDGError");
	m_pGetPodNum = (PGETPODNUM)GetProcAddress(m_hPMBusSDK, "GetPodNum");
	m_pSetOutputVolt = (PSETOUTPUTVOLT)GetProcAddress(m_hPMBusSDK, "SetOutputVolt");
	m_pOutputProtocol = (POUTPUTPROTOCOL)GetProcAddress(m_hPMBusSDK, "OutputProtocol");
	m_pGetProtocolName = (PGETPROTOCOLNAME)GetProcAddress(m_hPMBusSDK, "GetProtocolName");
	m_pInitProtocol = (PINITPROTOCOL)GetProcAddress(m_hPMBusSDK, "InitProtocol");
	m_pGetDGStatus  = (PGETDGSTATUS)GetProcAddress(m_hPMBusSDK, "GetDGStatus");
	m_pStopDG = (PSTOPDG)GetProcAddress(m_hPMBusSDK, "StopDG");
	m_pShutdownDG = (PSHUTDOWNDG)GetProcAddress(m_hPMBusSDK, "ShutdownDG");
	m_pPMBusInit = (PPMBUS_INIT)GetProcAddress(m_hPMBusSDK, "PMBus_Init");
	m_pAppendGroupCmdPtl = (PPMBUS_APPENDGROUPCMDPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendGroupCmdPtl");
	m_pAppendExtCmdRdBytePtl = (PPMBUS_APPENDEXTCMDRDBYTEPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendExtCmdRdBytePtl");
	m_pAppendExtCmdWrBytePtl = (PPMBUS_APPENDEXTCMDWRBYTEPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendExtCmdWrBytePtl");
	m_pAppendExtCmdRdWordPtl = (PPMBUS_APPENDEXTCMDRDWORDPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendExtCmdRdWordPtl");
	m_pAppendExtCmdWrWordPtl = (PPMBUS_APPENDEXTCMDWRWORDPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendExtCmdWrWordPtl");
	m_pAppendZoneRdStatDatResp = (PPMBUS_APPENDZONERDSTATDATRESP)GetProcAddress(m_hPMBusSDK, "PMBus_AppendZoneRdStatDatResp");
	m_pAppendZoneRdPMBusCmd = (PPMBUS_APPENDZONERDPMBUSCMD)GetProcAddress(m_hPMBusSDK, "PMBus_AppendZoneRdPMBusCmd");
	m_pAppendZoneWrPMBus_TwoDatByte = (PPMBUS_APPENDZONEWRPMBUS_TWODATBYTE)GetProcAddress(m_hPMBusSDK, "PMBus_AppendZoneWrPMBusCmd_TwoDatByte");
	m_pAppendAlertRespAddr = (PPMBUS_APPENDALERTRESPADDR)GetProcAddress(m_hPMBusSDK, "PMBus_AppendAlertRespAddr");
	m_pAppendIdle = (PPMBUS_APPENDIDLE)GetProcAddress(m_hPMBusSDK, "PMBus_AppendIdle");
	m_pAppendQuickCmdPtl = (PPMBUS_APPENDQUICKCMDPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendQuickCmdPtl");
	m_pAppendSendBytePtl = (PPMBUS_APPENDSENDBYTEPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendSendBytePtl");
	m_pAppendReceiveBytePtl = (PPMBUS_APPENDRECEIVEBYTEPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendReceiveBytePtl");
	m_pAppendWriteBytePtl = (PPMBUS_APPENDWRITEBYTEPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendWriteBytePtl");
	m_pAppendReadBytePtl = (PPMBUS_APPENDREADBYTEPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendReadBytePtl");
	m_pAppendWriteWordPtl = (PPMBUS_APPENDWRITEWORDPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendWriteWordPtl");
	m_pAppendReadWordPtl = (PPMBUS_APPENDREADWORDPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendReadWordPtl");
	m_pAppendWrite32Ptl = (PPMBUS_APPENDWRITE32PTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendWrite32Ptl");
	m_pAppendRead32Ptl = (PPMBUS_APPENDREAD32PTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendRead32Ptl");
	m_pAppendBlockWrPtl = (PPMBUS_APPENDBLOCKWRPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendBlockWrPtl");
	m_pAppendBlockRdPtl = (PPMBUS_APPENDBLOCKRDPTL)GetProcAddress(m_hPMBusSDK, "PMBus_AppendBlockRdPtl");

	if( !( m_pInitProtocol && m_pCloseProtocol && m_pClearProtocolPacket && m_pSaveProtocolList  &&
		   m_pAppendDGInstruction && m_pGetLastDGError &&  m_pGetPodNum && m_pSetOutputVolt && 
		   m_pOutputProtocol && m_pGetProtocolName && m_pInitProtocol && m_pGetDGStatus && m_pStopDG &&
		   m_pShutdownDG && m_pAppendGroupCmdPtl && m_pAppendExtCmdRdBytePtl &&
		   m_pAppendExtCmdWrBytePtl && m_pAppendExtCmdRdWordPtl && m_pAppendZoneRdStatDatResp &&
		   m_pAppendZoneRdPMBusCmd && m_pAppendZoneWrPMBus_TwoDatByte && m_pAppendAlertRespAddr &&
		   m_pAppendIdle && m_pAppendQuickCmdPtl && m_pAppendSendBytePtl && m_pAppendReceiveBytePtl &&
		   m_pAppendWriteBytePtl && m_pAppendReadBytePtl && m_pAppendWriteWordPtl && m_pAppendReadWordPtl &&
		   m_pAppendWrite32Ptl && m_pAppendRead32Ptl && m_pAppendBlockWrPtl && m_pAppendBlockRdPtl) )
		return;

	if(m_bnSinglePacket.GetCheck() == BST_CHECKED)
	{
		// Single Step
		// Init DG
		// Select TD3216B model and on line mode
		m_pInitProtocol(TD3216B, true);
//		m_pInitProtocol(DG3128B, true);

		//Input: 100 KHz PMBus protocol,  initial State: High, Single Step,  Scl ch No., Sda ch No., Not repeatedly output
		HDGPTL hDG = m_pPMBusInit(100, DGINIT_STATE_HIGH, true, 0, 1, DGFMT_DGW, true);
//		HDGPTL hDG = m_pPMBusInit(100, DGINIT_STATE_HIGH, false, 0, 1, DGFMT_DGV, false);

		int iErrorCode = m_pGetLastDGError();
		if(iErrorCode == ERR_MSG_NO_HARDWARE)
		{
			MessageBox("No DG!!", "PMBus SDK");
			if( m_hPMBusSDK )
				FreeLibrary( m_hPMBusSDK );
			return;
		}

		// Get the Pod number
		int iPodNums = m_pGetPodNum();

		// Set the Pod0 3V,  Pod0: CH0 ~ CH7
		m_pSetOutputVolt(3000, 0);
		// Set the Pod1 3V, Pod1: CH8 ~ CH15
		m_pSetOutputVolt(3000, 1);


		GROUP_CMD_PTL gcp;
		memset(&gcp, INVALID_DAT_VALUE, sizeof(GROUP_CMD_PTL));
		gcp.iDeviceSize = 1;
		gcp.cDevAddr[0] = 0x10;
		gcp.cCmdCode[0] = 0x16;
		gcp.cDatSize[0]  = 1;
		gcp.wWordDat[0] = 0x4020;
		DGADDR dgAddr = m_pAppendGroupCmdPtl(hDG, &gcp, true,  SET_HIZ);
		
		// Clear the PMBus packet list
		m_pClearProtocolPacket(hDG);

		// Release the PMBus packet list
		m_pCloseProtocol(hDG);

		// Stop & shutdown DG
		int iStatus = m_pGetDGStatus();
		::Sleep(1000);
		if(iStatus & DG_WAVEFORM_SENDING)
			m_pStopDG();
		m_pShutdownDG();


	}
	else
	{
		// Output in all PMBus packets way
		// Init DG
		// Select TD3216B model and off line mode
		m_pInitProtocol(TD3216B, true); // off line mode
//		m_pInitProtocol(TD3216B, true);  // on line mode
//		m_pInitProtocol(DG3128B, false);
//		m_pInitProtocol(DG3128B, true);

		//Input: 100 KHz PMBus protocol,  initial State: High, Not Single Step,  Scl ch No., Sda ch No., repeatedly output
		HDGPTL hDG = m_pPMBusInit(100, DGINIT_STATE_HIGH, false, 0, 1, DGFMT_DGW, true);
//		HDGPTL hDG = m_pPMBusInit(100, DGINIT_STATE_HIGH, false, 0, 1, DGFMT_DGV, true);

		// Get Protocol UID & Name
		char szPtlName[32];
		int iProtocolUID = m_pGetProtocolName(hDG, szPtlName, sizeof(szPtlName));

		// PMBus Packet

		GROUP_CMD_PTL gcp;
		memset(&gcp, INVALID_DAT_VALUE, sizeof(GROUP_CMD_PTL));
		gcp.iDeviceSize = 1;
		gcp.cDevAddr[0] = 0x10;
		gcp.cCmdCode[0] = 0x16;
		gcp.cDatSize[0]  = 1;
		gcp.wWordDat[0] = 0x4020;
		DGADDR dgAddr = m_pAppendGroupCmdPtl(hDG, &gcp, true,  SET_HIZ);

//		DGADDR dgAddr = m_pAppendExtCmdWrBytePtl(hDG, 0x10, 0xFF, 0x16, 0x20, true, SET_HIZ);
//		DGADDR dgAddr = m_pAppendExtCmdWrBytePtl(hDG, 0x10, 0xFF, 0x16, 0x20, false, SET_HIZ);
//		DGADDR dgAddr = m_pAppendExtCmdRdBytePtl(hDG, 0x10, 0xFF, 0x16, true, SET_HIZ);
//		DGADDR dgAddr = m_pAppendExtCmdRdWordPtl(hDG, 0x10, 0xFF, 0x16, true, SET_HIZ);
//		DGADDR dgAddr = m_pAppendExtCmdWrWordPtl(hDG, 0x10, 0xFF, 0x16, 0x4020, true, SET_HIZ);
//		DGADDR dgAddr = m_pAppendZoneRdStatDatResp(hDG, 0x10, 0xFF, SET_HIZ, 0x22, 0x44);// -1, None PEC
//		DGADDR dgAddr = m_pAppendZoneRdPMBusCmd(hDG, 0x10, 0xFF, SET_HIZ, 0x22, 0x44); // -1, None PEC
//		DGADDR dgAddr = m_pAppendZoneWrPMBus_TwoDatByte(hDG, 0x20, 0x2266, SET_HIZ);
//		DGADDR dgAddr = m_pAppendAlertRespAddr(hDG, 0x10, 0x2266, SET_HIZ);

		// 1 ms Idle
		m_pAppendIdle(hDG, 1000);

		// Get the Pod number
		int iPodNums = m_pGetPodNum();

		// Set the Tip0 3V,  Tip0: CH0 ~ CH7
		m_pSetOutputVolt(3000, 0);
		// Set the Tip1 3V, Tip1: CH8 ~ CH15
		m_pSetOutputVolt(3000, 1);

		int iFileSize = m_pSaveProtocolList(hDG, true, "PMBus.dgw");
//		int iFileSize = m_pSaveProtocolList(hDG, true, "PMBus.dgv");

		// Output  Protocol
		m_pOutputProtocol(hDG);
		
		// Clear the PMBus packet list
		m_pClearProtocolPacket(hDG);

		// Release the PMBus packet list
		m_pCloseProtocol(hDG);

		// Stop & shutdown DG
		int iStatus = m_pGetDGStatus();
		::Sleep(1000);
		if(iStatus & DG_WAVEFORM_SENDING)
			m_pStopDG();
		m_pShutdownDG();


	}

	if( m_hPMBusSDK )
		FreeLibrary( m_hPMBusSDK );


	MessageBox("Complete!", "PMBus SDK");


}
